/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ConditionalBlock;
import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.ParseException;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateObject;
import java.io.IOException;
import java.util.ArrayList;

final class IfBlock
extends TemplateElement {
    IfBlock(ConditionalBlock block) {
        this.nestedElements = new ArrayList();
        this.addBlock(block);
    }

    void addBlock(ConditionalBlock block) {
        this.nestedElements.add(block);
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            Expression condition = cblock.condition;
            if (condition != null && !condition.isTrue(env)) continue;
            if (cblock.nestedBlock != null) {
                env.visit(cblock.nestedBlock);
            }
            return;
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            buf.append(cblock.getCanonicalForm());
        }
        buf.append("</#if>");
        return buf.toString();
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        if (this.nestedElements.size() == 1) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(0);
            cblock.isSimple = true;
            cblock.setLocation(this.getTemplate(), (TemplateObject)cblock, (TemplateObject)this);
            return cblock.postParseCleanup(stripWhitespace);
        }
        return super.postParseCleanup(stripWhitespace);
    }

    public String getDescription() {
        return "if-else ";
    }
}

