/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.Environment;
import freemarker.template.Expression;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.CaptureOutput;
import java.io.IOException;
import java.util.HashMap;

final class BlockAssignment
extends TemplateElement {
    private String varName;
    private String keyName;
    private Expression namespaceExp;

    BlockAssignment(TemplateElement nestedBlock, String varName, int scope, Expression namespaceExp) {
        this.nestedBlock = nestedBlock;
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.keyName = "var";
        if (scope == 2) {
            this.keyName = "local";
        } else if (scope == 3) {
            this.keyName = "global";
        }
    }

    void accept(Environment env) throws TemplateException, IOException {
        HashMap<String, TemplateModel> args = new HashMap<String, TemplateModel>();
        args.put(this.keyName, new SimpleScalar(this.varName));
        if (this.namespaceExp != null) {
            args.put("namespace", this.namespaceExp.getAsTemplateModel(env));
        }
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock, new CaptureOutput(), args);
        }
    }

    public String getCanonicalForm() {
        String key = this.keyName == "var" ? "assign" : this.keyName;
        return "<#" + key + " " + this.varName + ">" + this.nestedBlock.getCanonicalForm() + "</#" + key + ">";
    }

    public String getDescription() {
        return "block assignment to variable: " + this.varName;
    }

    boolean isIgnorable() {
        return false;
    }
}

