/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BooleanModel;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.DateModel;
import freemarker.ext.beans.EnumerationModel;
import freemarker.ext.beans.IteratorModel;
import freemarker.ext.beans.MapModel;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.NumberModel;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.ext.beans.SimpleMapModel;
import freemarker.ext.beans.StaticModels;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.SecurityUtilities;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class BeansWrapper
implements ObjectWrapper {
    private static final boolean DEVELOPMENT = "true".equals(SecurityUtilities.getSystemProperty("freemarker.development"));
    private static final Class BIGINTEGER_CLASS = class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeansWrapper.class$("java.math.BigInteger")) : class$java$math$BigInteger;
    private static final Logger logger = Logger.getLogger("freemarker.beans");
    private static final Set UNSAFE_METHODS = BeansWrapper.createUnsafeMethodsSet();
    static final Object GENERIC_GET_KEY = new Object();
    private static final Object CONSTRUCTORS = new Object();
    private static final BeansWrapper INSTANCE = new BeansWrapper();
    private final Map classCache = new HashMap();
    private Set cachedClassNames = new HashSet();
    private final StaticModels staticModels = new StaticModels(this);
    private final ModelCache modelCache = new ModelCache(this);
    private final BooleanModel FALSE = new BooleanModel(Boolean.FALSE, this);
    private final BooleanModel TRUE = new BooleanModel(Boolean.TRUE, this);
    public static final int EXPOSE_ALL = 0;
    public static final int EXPOSE_SAFE = 1;
    public static final int EXPOSE_PROPERTIES_ONLY = 2;
    public static final int EXPOSE_NOTHING = 3;
    private int exposureLevel = 1;
    private TemplateModel nullModel = null;
    private boolean methodsShadowItems = true;
    private int defaultDateType = 0;
    private ObjectWrapper outerIdentity = this;
    private boolean simpleMapWrapper;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$freemarker$ext$beans$BeansWrapper;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;

    public void setOuterIdentity(ObjectWrapper outerIdentity) {
        this.outerIdentity = outerIdentity;
    }

    public ObjectWrapper getOuterIdentity() {
        return this.outerIdentity;
    }

    public void setSimpleMapWrapper(boolean simpleMapWrapper) {
        this.simpleMapWrapper = simpleMapWrapper;
    }

    public boolean isSimpleMapWrapper() {
        return this.simpleMapWrapper;
    }

    public void setExposureLevel(int exposureLevel) {
        if (exposureLevel < 0 || exposureLevel > 3) {
            throw new IllegalArgumentException("Illegal exposure level " + exposureLevel);
        }
        this.exposureLevel = exposureLevel;
    }

    int getExposureLevel() {
        return this.exposureLevel;
    }

    public synchronized void setMethodsShadowItems(boolean methodsShadowItems) {
        this.methodsShadowItems = methodsShadowItems;
    }

    boolean isMethodsShadowItems() {
        return this.methodsShadowItems;
    }

    public synchronized void setDefaultDateType(int defaultDateType) {
        this.defaultDateType = defaultDateType;
    }

    int getDefaultDateType() {
        return this.defaultDateType;
    }

    public void setUseCache(boolean useCache) {
        this.modelCache.setUseCache(useCache);
    }

    public void setNullModel(TemplateModel nullModel) {
        this.nullModel = nullModel;
    }

    public static final BeansWrapper getDefaultInstance() {
        return INSTANCE;
    }

    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object == null) {
            return this.nullModel;
        }
        if (object instanceof TemplateModel) {
            return (TemplateModel)object;
        }
        if (object instanceof Map) {
            return this.modelCache.getInstance(object, this.simpleMapWrapper ? SimpleMapModel.FACTORY : MapModel.FACTORY);
        }
        if (object instanceof Collection) {
            return this.modelCache.getInstance(object, CollectionModel.FACTORY);
        }
        if (object.getClass().isArray()) {
            return this.modelCache.getInstance(object, ArrayModel.FACTORY);
        }
        if (object instanceof Number) {
            return this.modelCache.getInstance(object, NumberModel.FACTORY);
        }
        if (object instanceof Date) {
            return this.modelCache.getInstance(object, DateModel.FACTORY);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? this.TRUE : this.FALSE;
        }
        if (object instanceof ResourceBundle) {
            return this.modelCache.getInstance(object, ResourceBundleModel.FACTORY);
        }
        if (object instanceof Iterator) {
            return new IteratorModel((Iterator)object, this);
        }
        if (object instanceof Enumeration) {
            return new EnumerationModel((Enumeration)object, this);
        }
        return this.modelCache.getInstance(object, StringModel.FACTORY);
    }

    protected TemplateModel create(Object object, Object factory) {
        return ((ModelFactory)factory).create(object, this);
    }

    public Object unwrap(TemplateModel model) throws TemplateModelException {
        if (model == this.nullModel) {
            return null;
        }
        if (model instanceof WrapperTemplateModel) {
            return ((WrapperTemplateModel)model).getWrappedObject();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber();
        }
        if (model instanceof TemplateDateModel) {
            return ((TemplateDateModel)model).getAsDate();
        }
        if (model instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        return model;
    }

    Object[] unwrapArguments(List arguments) throws TemplateModelException {
        Object[] args = null;
        if (arguments != null) {
            int size = arguments.size();
            args = new Object[size];
            Iterator it = arguments.iterator();
            int i = 0;
            while (it.hasNext()) {
                args[i++] = this.unwrap((TemplateModel)it.next());
            }
        }
        return args;
    }

    public TemplateHashModel getStaticModels() {
        return this.staticModels;
    }

    public Object newInstance(Class clazz, List arguments) throws TemplateModelException {
        try {
            this.introspectClass(clazz);
            Object ctors = ((Map)this.classCache.get(clazz)).get(CONSTRUCTORS);
            if (ctors == null) {
                throw new TemplateModelException("Class " + clazz.getName() + " has no public constructors.");
            }
            Constructor ctor = null;
            Object[] objargs = this.unwrapArguments(arguments);
            if (ctors instanceof Constructor) {
                ctor = (Constructor)ctors;
            } else if (ctors instanceof MethodMap) {
                ctor = (Constructor)((MethodMap)ctors).getMostSpecific(objargs);
            } else {
                throw new Error();
            }
            if (objargs != null) {
                BeansWrapper.coerceBigDecimals(ctor, objargs);
            }
            return ctor.newInstance(objargs);
        }
        catch (TemplateModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateModelException("Could not create instance of class " + clazz.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspectClass(Class clazz) {
        Map map = this.classCache;
        synchronized (map) {
            if (!this.classCache.containsKey(clazz)) {
                String className = clazz.getName();
                if (this.cachedClassNames.contains(className)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Detected a reloaded class [" + className + "]. Clearing BeansWrapper caches.");
                    }
                    this.classCache.clear();
                    this.cachedClassNames = new HashSet();
                    BeansWrapper beansWrapper = this;
                    synchronized (beansWrapper) {
                        this.modelCache.clearCache();
                    }
                    this.staticModels.clearCache();
                }
                this.classCache.put(clazz, this.populateClassMap(clazz));
                this.cachedClassNames.add(className);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getClassKeyMap(Class clazz) {
        Map map = this.classCache;
        synchronized (map) {
            return (Map)this.classCache.get(clazz);
        }
    }

    int keyCount(Class clazz) {
        Map map = this.getClassKeyMap(clazz);
        int count = map.size();
        if (map.containsKey(CONSTRUCTORS)) {
            --count;
        }
        if (map.containsKey(GENERIC_GET_KEY)) {
            --count;
        }
        return count;
    }

    Set keySet(Class clazz) {
        HashSet set = new HashSet(this.getClassKeyMap(clazz).keySet());
        set.remove(CONSTRUCTORS);
        set.remove(GENERIC_GET_KEY);
        return set;
    }

    private Map populateClassMap(Class clazz) {
        Map map = this.populateClassMapWithBeanInfo(clazz);
        try {
            Constructor<?>[] ctors = clazz.getConstructors();
            if (ctors.length == 1) {
                map.put(CONSTRUCTORS, ctors[0]);
            } else if (ctors.length > 1) {
                MethodMap ctorMap = new MethodMap("<init>");
                for (int i = 0; i < ctors.length; ++i) {
                    ctorMap.addConstructor(ctors[i]);
                }
                map.put(CONSTRUCTORS, ctorMap);
            }
        }
        catch (SecurityException e) {
            logger.warn("Canont discover constructors for class " + clazz.getName(), e);
        }
        switch (map.size()) {
            case 0: {
                map = Collections12.EMPTY_MAP;
                break;
            }
            case 1: {
                Map.Entry e = map.entrySet().iterator().next();
                map = Collections12.singletonMap(e.getKey(), e.getValue());
                break;
            }
        }
        return map;
    }

    private Map populateClassMapWithBeanInfo(Class clazz) {
        HashMap<Object, Object> classMap = new HashMap<Object, Object>();
        Map accessibleMethods = BeansWrapper.discoverAccessibleMethods(clazz);
        Method genericGet = (Method)accessibleMethods.get(MethodSignature.GET_STRING_SIGNATURE);
        if (genericGet == null) {
            genericGet = (Method)accessibleMethods.get(MethodSignature.GET_OBJECT_SIGNATURE);
        }
        if (genericGet != null) {
            classMap.put(GENERIC_GET_KEY, genericGet);
        }
        if (this.exposureLevel == 3) {
            return classMap;
        }
        try {
            int i;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pda = beanInfo.getPropertyDescriptors();
            MethodDescriptor[] mda = beanInfo.getMethodDescriptors();
            for (i = pda.length - 1; i >= 0; --i) {
                PropertyDescriptor pd = pda[i];
                if (pd instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    Method readMethod = ipd.getIndexedReadMethod();
                    Method publicReadMethod = BeansWrapper.getAccessibleMethod(readMethod, accessibleMethods);
                    if (publicReadMethod == null || !this.isSafeMethod(publicReadMethod)) continue;
                    try {
                        if (readMethod != publicReadMethod) {
                            ipd.setIndexedReadMethod(publicReadMethod);
                        }
                        classMap.put(ipd.getName(), ipd);
                    }
                    catch (IntrospectionException e) {
                        logger.warn("Couldn't properly perform introspection", e);
                    }
                    continue;
                }
                Method readMethod = pd.getReadMethod();
                Method publicReadMethod = BeansWrapper.getAccessibleMethod(readMethod, accessibleMethods);
                if (publicReadMethod == null || !this.isSafeMethod(publicReadMethod)) continue;
                try {
                    if (readMethod != publicReadMethod) {
                        pd.setReadMethod(publicReadMethod);
                    }
                    classMap.put(pd.getName(), pd);
                    continue;
                }
                catch (IntrospectionException e) {
                    logger.warn("Couldn't properly perform introspection", e);
                }
            }
            if (this.exposureLevel < 2) {
                for (i = mda.length - 1; i >= 0; --i) {
                    MethodDescriptor md = mda[i];
                    Method method = md.getMethod();
                    Method publicMethod = BeansWrapper.getAccessibleMethod(method, accessibleMethods);
                    if (publicMethod == null || !this.isSafeMethod(publicMethod)) continue;
                    String name = md.getName();
                    Object previous = classMap.get(name);
                    if (previous instanceof Method) {
                        MethodMap methodMap = new MethodMap(name);
                        methodMap.addMethod((Method)previous);
                        methodMap.addMethod(publicMethod);
                        classMap.put(name, methodMap);
                        continue;
                    }
                    if (previous instanceof MethodMap) {
                        ((MethodMap)previous).addMethod(publicMethod);
                        continue;
                    }
                    classMap.put(name, publicMethod);
                }
            }
            return classMap;
        }
        catch (IntrospectionException e) {
            logger.warn("Couldn't properly perform introspection", e);
            return new HashMap();
        }
    }

    private static Method getAccessibleMethod(Method m, Map accessibles) {
        return m == null ? null : (Method)accessibles.get(new MethodSignature(m));
    }

    boolean isSafeMethod(Method method) {
        return this.exposureLevel < 1 || !UNSAFE_METHODS.contains(method);
    }

    private static Map discoverAccessibleMethods(Class clazz) {
        HashMap map = new HashMap();
        BeansWrapper.discoverAccessibleMethods(clazz, map);
        return map;
    }

    private static void discoverAccessibleMethods(Class clazz, Map map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methods = clazz.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    MethodSignature sig = new MethodSignature(method);
                    map.put(sig, method);
                }
                return;
            }
            catch (SecurityException e) {
                logger.warn("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.", e);
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            BeansWrapper.discoverAccessibleMethods(interfaces[i], map);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            BeansWrapper.discoverAccessibleMethods(superclass, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Set createUnsafeMethodsSet() {
        Properties props = new Properties();
        InputStream in = (class$freemarker$ext$beans$BeansWrapper == null ? (class$freemarker$ext$beans$BeansWrapper = BeansWrapper.class$("freemarker.ext.beans.BeansWrapper")) : class$freemarker$ext$beans$BeansWrapper).getResourceAsStream("unsafeMethods.txt");
        if (in == null) return Collections.EMPTY_SET;
        String methodSpec = null;
        try {
            try {
                props.load(in);
            }
            finally {
                in.close();
            }
            HashSet<Method> set = new HashSet<Method>(props.size() * 4 / 3, 0.75f);
            Map primClasses = BeansWrapper.createPrimitiveClassesMap();
            Iterator<Object> iterator = props.keySet().iterator();
            while (iterator.hasNext()) {
                methodSpec = (String)iterator.next();
                try {
                    set.add(BeansWrapper.parseMethodSpec(methodSpec, primClasses));
                }
                catch (ClassNotFoundException e) {
                    if (!DEVELOPMENT) continue;
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    if (!DEVELOPMENT) continue;
                    throw e;
                    return Collections.EMPTY_SET;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load unsafe method " + methodSpec + " " + e.getClass().getName() + " " + e.getMessage());
        }
    }

    private static Method parseMethodSpec(String methodSpec, Map primClasses) throws ClassNotFoundException, NoSuchMethodException {
        int brace = methodSpec.indexOf(40);
        int dot = methodSpec.lastIndexOf(46, brace);
        Class clazz = ClassUtil.forName(methodSpec.substring(0, dot));
        String methodName = methodSpec.substring(dot + 1, brace);
        String argSpec = methodSpec.substring(brace + 1, methodSpec.length() - 1);
        StringTokenizer tok = new StringTokenizer(argSpec, ",");
        int argcount = tok.countTokens();
        Class[] argTypes = new Class[argcount];
        for (int i = 0; i < argcount; ++i) {
            String argClassName = tok.nextToken();
            argTypes[i] = (Class)primClasses.get(argClassName);
            if (argTypes[i] != null) continue;
            argTypes[i] = ClassUtil.forName(argClassName);
        }
        return clazz.getMethod(methodName, argTypes);
    }

    private static Map createPrimitiveClassesMap() {
        HashMap<String, Class<Comparable<Boolean>>> map = new HashMap<String, Class<Comparable<Boolean>>>();
        map.put("boolean", Boolean.TYPE);
        map.put("byte", Byte.TYPE);
        map.put("char", Character.TYPE);
        map.put("short", Short.TYPE);
        map.put("int", Integer.TYPE);
        map.put("long", Long.TYPE);
        map.put("float", Float.TYPE);
        map.put("double", Double.TYPE);
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static void coerceBigDecimals(AccessibleObject callable, Object[] args) {
        Class<?>[] formalTypes = null;
        int l = args.length;
        for (int i = 0; i < l; ++i) {
            void formalType;
            Object arg = args[i];
            if (!(arg instanceof BigDecimal)) continue;
            BigDecimal bd = (BigDecimal)arg;
            if (formalTypes == null) {
                if (callable instanceof Method) {
                    formalTypes = ((Method)callable).getParameterTypes();
                } else if (callable instanceof Constructor) {
                    formalTypes = ((Constructor)callable).getParameterTypes();
                } else {
                    throw new Error();
                }
                if (formalTypes.length != l) {
                    return;
                }
            }
            if ((formalType = formalTypes[i]) == Integer.TYPE || formalType == (class$java$lang$Integer == null ? BeansWrapper.class$("java.lang.Integer") : class$java$lang$Integer)) {
                args[i] = new Integer(bd.intValue());
                continue;
            }
            if (formalType == Double.TYPE || formalType == (class$java$lang$Double == null ? BeansWrapper.class$("java.lang.Double") : class$java$lang$Double)) {
                args[i] = new Double(bd.doubleValue());
                continue;
            }
            if (formalType == Long.TYPE || formalType == (class$java$lang$Long == null ? BeansWrapper.class$("java.lang.Long") : class$java$lang$Long)) {
                args[i] = new Long(bd.longValue());
                continue;
            }
            if (formalType == Float.TYPE || formalType == (class$java$lang$Float == null ? BeansWrapper.class$("java.lang.Float") : class$java$lang$Float)) {
                args[i] = new Float(bd.floatValue());
                continue;
            }
            if (formalType == Short.TYPE || formalType == (class$java$lang$Short == null ? BeansWrapper.class$("java.lang.Short") : class$java$lang$Short)) {
                args[i] = new Short(bd.shortValue());
                continue;
            }
            if (formalType == Byte.TYPE || formalType == (class$java$lang$Byte == null ? BeansWrapper.class$("java.lang.Byte") : class$java$lang$Byte)) {
                args[i] = new Byte(bd.byteValue());
                continue;
            }
            if (!BIGINTEGER_CLASS.isAssignableFrom((Class<?>)formalType)) continue;
            args[i] = bd.toBigInteger();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class MethodSignature {
        private static final MethodSignature GET_STRING_SIGNATURE = new MethodSignature("get", new Class[]{class$java$lang$String == null ? (class$java$lang$String = BeansWrapper.class$("java.lang.String")) : class$java$lang$String});
        private static final MethodSignature GET_OBJECT_SIGNATURE = new MethodSignature("get", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = BeansWrapper.class$("java.lang.Object")) : class$java$lang$Object});
        private final String name;
        private final Class[] args;

        private MethodSignature(String name, Class[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

