/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.core.MailImpl;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.masukomi.aspirin.core.MailWatcher;
import org.masukomi.aspirin.core.QueManager;
import org.masukomi.aspirin.core.QuedItem;

public class MailQue {
    private static Log log = LogFactory.getLog((Class)(class$org$masukomi$aspirin$core$MailQue == null ? (class$org$masukomi$aspirin$core$MailQue = MailQue.class$("org.masukomi.aspirin.core.MailQue")) : class$org$masukomi$aspirin$core$MailQue));
    protected QueManager qm = new QueManager();
    protected Vector que = new Vector();
    protected Vector listeners = new Vector();
    static MailQue mq;
    private Vector listenersToRemove = new Vector();
    private Vector listenersToAdd = new Vector();
    private int notificationCount = 0;
    static /* synthetic */ Class class$org$masukomi$aspirin$core$MailQue;

    public static MailQue getInstance() {
        if (mq == null) {
            mq = new MailQue();
        }
        return mq;
    }

    private MailQue() {
    }

    public static void queMail(MimeMessage message) throws MessagingException {
        MailImpl mail = new MailImpl(message);
        MailQue.service(mail, MailQue.getInstance().getListeners());
        if (!MailQue.getInstance().getQueManager().isRunning()) {
            MailQue.getInstance().getQueManager().start();
        }
    }

    protected static void service(Mail genericmail, Collection watchers) throws AddressException {
        MailImpl mail = (MailImpl)genericmail;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remotely delivering mail " + mail.getName()));
        }
        Collection recipients = mail.getRecipients();
        Hashtable<String, Vector<MailAddress>> targets = new Hashtable<String, Vector<MailAddress>>();
        Iterator i = recipients.iterator();
        while (i.hasNext()) {
            MailAddress target = (MailAddress)i.next();
            String targetServer = target.getHost().toLowerCase(Locale.US);
            Vector<MailAddress> temp = (Vector<MailAddress>)targets.get(targetServer);
            if (temp == null) {
                temp = new Vector<MailAddress>();
                targets.put(targetServer, temp);
            }
            temp.add(target);
        }
        String name = mail.getName();
        Iterator i2 = targets.keySet().iterator();
        while (i2.hasNext()) {
            String host = (String)i2.next();
            Collection rec = (Collection)targets.get(host);
            if (log.isDebugEnabled()) {
                StringBuffer logMessageBuffer = new StringBuffer(128).append("Sending mail to ").append(rec).append(" on host ").append(host);
                log.debug((Object)logMessageBuffer.toString());
            }
            mail.setRecipients(rec);
            StringBuffer nameBuffer = new StringBuffer(128).append(name).append("-to-").append(host);
            mail.setName(nameBuffer.toString());
            MailQue.store(new QuedItem(mail));
        }
        mail.setState("ghost");
    }

    protected static void store(QuedItem qi) {
        MailQue.getInstance().getQue().add(qi);
    }

    public static synchronized QuedItem getNextSendable() {
        Collections.sort(MailQue.getInstance().getQue());
        Iterator it = MailQue.getInstance().getQue().iterator();
        while (it.hasNext()) {
            QuedItem qi = (QuedItem)it.next();
            if (!qi.isReadyToSend()) continue;
            return qi;
        }
        Vector que = MailQue.getInstance().getQue();
        if (que.size() > 0) {
            for (int i = que.size() - 1; i > -1; --i) {
                QuedItem qi = (QuedItem)que.elementAt(i);
                if (qi.getStatus() != QuedItem.COMPLETED) continue;
                que.remove(i);
            }
        }
        return null;
    }

    public static void reQue(QuedItem item) {
        if (MailQue.getInstance().getQue().indexOf(item) == -1) {
            MailQue.getInstance().getQue().add(item);
        }
    }

    QueManager getQueManager() {
        if (this.qm == null) {
            this.qm = new QueManager();
        }
        return this.qm;
    }

    public Vector getQue() {
        return this.que;
    }

    public static void addListener(MailWatcher watcher) {
        MailQue.addWatcher(watcher);
    }

    public static void addWatcher(MailWatcher watcher) {
        if (!MailQue.getInstance().isNotifying()) {
            MailQue.getInstance().getListeners().add(watcher);
        } else {
            MailQue.getInstance().getQueManager().pauseNewSends();
            MailQue.getInstance().listenersToAdd.add(watcher);
        }
    }

    public static void removeListener(MailWatcher watcher) {
        MailQue.removeWatcher(watcher);
    }

    public static void removeWatcher(MailWatcher watcher) {
        if (!MailQue.getInstance().isNotifying()) {
            MailQue.getInstance().getListeners().remove(watcher);
        } else {
            MailQue.getInstance().getQueManager().pauseNewSends();
            MailQue.getInstance().listenersToRemove.add(watcher);
        }
    }

    public Vector getListeners() {
        return this.listeners;
    }

    public synchronized void incrementNotifiersCount() {
        ++this.notificationCount;
    }

    public synchronized void decrementNotifiersCount() {
        --this.notificationCount;
        if (this.notificationCount == 0) {
            Iterator removersIt = this.listenersToRemove.iterator();
            while (removersIt.hasNext()) {
                this.listeners.add(removersIt.next());
            }
            this.listenersToRemove.clear();
            Iterator addersIt = this.listenersToAdd.iterator();
            while (addersIt.hasNext()) {
                this.listeners.add(addersIt.next());
            }
            this.listenersToAdd.clear();
            MailQue.getInstance().getQueManager().unPauseNewSends();
        }
    }

    public synchronized boolean isNotifying() {
        return this.notificationCount != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

