/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.james.util.RFC822DateFormat;

public class RFC822Date {
    private static SimpleDateFormat df = new SimpleDateFormat("EE, d MMM yyyy HH:mm:ss", Locale.US);
    private static SimpleDateFormat dx = new SimpleDateFormat("EE, d MMM yyyy HH:mm:ss zzzzz", Locale.US);
    private static SimpleDateFormat dy = new SimpleDateFormat("EE d MMM yyyy HH:mm:ss zzzzz", Locale.US);
    private static SimpleDateFormat dz = new SimpleDateFormat("d MMM yyyy HH:mm:ss zzzzz", Locale.US);
    private Date d;
    private RFC822DateFormat rfc822Format = new RFC822DateFormat();

    public RFC822Date() {
        this.d = new Date();
    }

    public RFC822Date(Date da) {
        this.d = da;
    }

    public RFC822Date(Date da, String useTZ) {
        this.d = da;
    }

    public RFC822Date(String rfcdate) {
        this.setDate(rfcdate);
    }

    public RFC822Date(String rfcdate, String useTZ) {
        this.setDate(rfcdate);
        this.setTimeZone(useTZ);
    }

    public void setDate(Date da) {
        this.d = da;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(String rfcdate) {
        try {
            SimpleDateFormat simpleDateFormat = dx;
            synchronized (simpleDateFormat) {
                this.d = dx.parse(rfcdate);
            }
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat simpleDateFormat = dz;
                synchronized (simpleDateFormat) {
                    this.d = dz.parse(rfcdate);
                }
            }
            catch (ParseException f) {
                try {
                    SimpleDateFormat simpleDateFormat = dy;
                    synchronized (simpleDateFormat) {
                        this.d = dy.parse(rfcdate);
                    }
                }
                catch (ParseException g) {
                    this.d = new Date();
                }
            }
        }
    }

    public void setTimeZone(TimeZone useTZ) {
        this.rfc822Format.setTimeZone(useTZ);
    }

    public void setTimeZone(String useTZ) {
        this.setTimeZone(TimeZone.getTimeZone(useTZ));
    }

    public Date getDate() {
        return this.d;
    }

    public String toString() {
        return this.rfc822Format.format(this.d);
    }
}

