/*
 * Decompiled with CFR 0.152.
 */
package com.jsptags.navigation.pager;

import com.jsptags.navigation.pager.PageTagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public abstract class JumpTagSupport
extends PageTagSupport {
    static final String CURRENT = "current";
    static final String INDEXED = "indexed";
    private String unless = null;

    public final void setUnless(String value) throws JspException {
        if (value != null && !CURRENT.equals(value) && !INDEXED.equals(value)) {
            throw new JspTagException("value for attribute \"unless\" must be either \"current\" or \"indexed\".");
        }
        this.unless = value;
    }

    public final String getUnless() {
        return this.unless;
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        int jumpPage = this.getJumpPage();
        if (CURRENT.equals(this.unless)) {
            if (jumpPage == this.pagerTag.getPageNumber()) {
                return 0;
            }
        } else if (INDEXED.equals(this.unless)) {
            int firstPage = this.pagerTag.getFirstIndexPage();
            int lastPage = this.pagerTag.getLastIndexPage(firstPage);
            if (jumpPage >= firstPage && jumpPage <= lastPage) {
                return 0;
            }
        }
        this.setPageAttributes(jumpPage);
        return 1;
    }

    public void release() {
        this.unless = null;
        super.release();
    }

    protected abstract int getJumpPage();
}

