/*
 * Decompiled with CFR 0.152.
 */
package org.masukomi.aspirin.core;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.masukomi.aspirin.core.Bouncer;
import org.masukomi.aspirin.core.Configuration;
import org.masukomi.aspirin.core.MailQue;
import org.masukomi.aspirin.core.MailWatcher;

public class QuedItem
implements Comparable {
    private static Log log = LogFactory.getLog((Class)(class$org$masukomi$aspirin$core$QuedItem == null ? (class$org$masukomi$aspirin$core$QuedItem = QuedItem.class$("org.masukomi.aspirin.core.QuedItem")) : class$org$masukomi$aspirin$core$QuedItem));
    protected Mail mail;
    protected long nextAttempt;
    public static int IN_QUE = 0;
    public static int IN_PROCESS = 1;
    public static int COMPLETED = 3;
    protected int status = 0;
    protected HashMap recipientFailures;
    protected HashMap recipientSuccesses;
    protected int numSuccesses;
    protected int numFailures;
    static /* synthetic */ Class class$org$masukomi$aspirin$core$QuedItem;

    public QuedItem(Mail mail) {
        this.mail = mail;
        this.nextAttempt = System.currentTimeMillis();
    }

    public Mail getMail() {
        return this.mail;
    }

    public long getNextAttempt() {
        return this.nextAttempt;
    }

    public int getNumAttempts() {
        return 0;
    }

    public int compareTo(Object o) {
        try {
            if (((QuedItem)o).getNextAttempt() > this.getNextAttempt()) {
                return -1;
            }
            if (((QuedItem)o).getNextAttempt() < this.getNextAttempt()) {
                return 1;
            }
            return 0;
        }
        catch (ClassCastException cce) {
            return 0;
        }
    }

    public void failForRecipient(MailAddress recipient) {
        ++this.numFailures;
        if (this.recipientFailures == null) {
            this.recipientFailures = new HashMap();
        }
        this.recipientFailures.put(recipient, new Integer(3));
        if (MailQue.getInstance().getListeners() != null) {
            MailQue.getInstance().incrementNotifiersCount();
            Iterator it = MailQue.getInstance().getListeners().iterator();
            while (it.hasNext()) {
                MailWatcher watcher = (MailWatcher)it.next();
                try {
                    watcher.deliveryFailure(this.getMail().getMessage(), this.getMail().getRecipients());
                    watcher.deliveryFailure(this.getMail().getMessage(), recipient);
                }
                catch (MessagingException e) {
                    log.error((Object)e);
                }
            }
            MailQue.getInstance().decrementNotifiersCount();
        }
        if (this.isCompleted()) {
            this.setStatus(COMPLETED);
        }
    }

    public void retry(MailAddress recipient) {
        MailQue.reQue(this);
        if (this.retryable(recipient)) {
            if (this.recipientFailures.containsKey(recipient)) {
                Integer numFailures = (Integer)this.recipientFailures.get(recipient);
                this.recipientFailures.put(recipient, new Integer(numFailures + 1));
            } else {
                this.recipientFailures.put(recipient, new Integer(1));
            }
            this.nextAttempt = System.currentTimeMillis() + Configuration.getInstance().getRetryInterval();
            this.setStatus(IN_QUE);
            if (log.isTraceEnabled()) {
                log.trace((Object)("will retry message at " + new Date(this.nextAttempt).toString()));
            }
        } else {
            try {
                this.failForRecipient(recipient);
                Bouncer.bounce(this.getMail(), "Maxumum retries exceeded for " + recipient, Configuration.getInstance().getPostmaster());
            }
            catch (MessagingException e) {
                log.error((Object)e);
            }
        }
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public boolean retryable(MailAddress recipient) {
        if (this.recipientFailures == null) {
            this.recipientFailures = new HashMap();
        }
        if (this.recipientFailures.containsKey(recipient)) {
            Integer numFailures = (Integer)this.recipientFailures.get(recipient);
            return numFailures + 1 < Configuration.getInstance().getMaxAttempts();
        }
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isReadyToSend() {
        if (this.getStatus() != IN_QUE) {
            return false;
        }
        return this.nextAttempt <= System.currentTimeMillis();
    }

    public void succeededForRecipient(MailAddress recipient) {
        ++this.numSuccesses;
        if (this.recipientSuccesses == null) {
            this.recipientSuccesses = new HashMap();
        }
        this.recipientSuccesses.put(recipient, null);
        if (MailQue.getInstance().getListeners() != null && MailQue.getInstance().getListeners().size() > 0) {
            MailQue.getInstance().incrementNotifiersCount();
            Iterator it = MailQue.getInstance().getListeners().iterator();
            while (it.hasNext()) {
                MailWatcher watcher = (MailWatcher)it.next();
                try {
                    Vector<MailAddress> recipients = new Vector<MailAddress>();
                    recipients.add(recipient);
                    watcher.deliverySuccess(this.getMail().getMessage(), recipients);
                    watcher.deliverySuccess(this.getMail().getMessage(), recipient);
                }
                catch (MessagingException e) {
                    log.error((Object)e);
                }
            }
            MailQue.getInstance().decrementNotifiersCount();
        }
        if (this.isCompleted()) {
            this.setStatus(COMPLETED);
        }
    }

    boolean isCompleted() {
        return this.numSuccesses + this.numFailures >= this.getMail().getRecipients().size();
    }

    boolean recepientHasBeenHandled(MailAddress recipient) {
        if (this.recipientSuccesses != null && this.recipientSuccesses.containsKey(recipient)) {
            return true;
        }
        return this.recipientFailures != null && (Integer)this.recipientFailures.get(recipient) > 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

