/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.james.core.MimeMessageInputStreamSource;
import org.apache.james.core.MimeMessageWrapper;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class MailImpl
implements Mail {
    public static final long serialVersionUID = -4289663364703986260L;
    private String errorMessage;
    private String state;
    private MimeMessage message;
    private MailAddress sender;
    private Collection recipients;
    private String name;
    private String remoteHost = "localhost";
    private String remoteAddr = "127.0.0.1";
    private Date lastUpdated = new Date();

    public MailImpl() {
        this.setState("root");
    }

    public MailImpl(String name, MailAddress sender, Collection recipients) {
        this();
        this.name = name;
        this.sender = sender;
        this.recipients = null;
        if (recipients != null) {
            Iterator theIterator = recipients.iterator();
            this.recipients = new ArrayList();
            while (theIterator.hasNext()) {
                this.recipients.add(theIterator.next());
            }
        }
    }

    public MailImpl(String name, MailAddress sender, Collection recipients, InputStream messageIn) throws MessagingException {
        this(name, sender, recipients);
        MimeMessageInputStreamSource source = new MimeMessageInputStreamSource(name, messageIn);
        MimeMessageWrapper wrapper = new MimeMessageWrapper(source);
        this.setMessage(wrapper);
    }

    public MailImpl(String name, MailAddress sender, Collection recipients, MimeMessage message) {
        this(name, sender, recipients);
        this.setMessage(message);
    }

    public MailImpl(MimeMessage message) throws MessagingException {
        this();
        Address[] addresses = message.getFrom();
        MailAddress sender = new MailAddress(new InternetAddress(addresses[0].toString()));
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>();
        addresses = message.getRecipients(MimeMessage.RecipientType.TO);
        for (int i = 0; i < addresses.length; ++i) {
            recipients.add(new MailAddress(new InternetAddress(addresses[i].toString())));
        }
        this.name = message.toString();
        this.sender = sender;
        this.recipients = recipients;
        this.setMessage(message);
    }

    public Mail duplicate() {
        return this.duplicate(this.name);
    }

    public Mail duplicate(String newName) {
        try {
            MailImpl newMail = new MailImpl(newName, this.sender, this.recipients, this.getMessage());
            newMail.setRemoteHost(this.remoteHost);
            newMail.setRemoteAddr(this.remoteAddr);
            newMail.setLastUpdated(this.lastUpdated);
            return newMail;
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MimeMessage getMessage() throws MessagingException {
        return this.message;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection getRecipients() {
        return this.recipients;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public String getState() {
        return this.state;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public long getMessageSize() throws MessagingException {
        if (this.message instanceof MimeMessageWrapper) {
            MimeMessageWrapper wrapper = (MimeMessageWrapper)this.message;
            return wrapper.getMessageSize();
        }
        long size = this.message.getSize();
        Enumeration e = this.message.getAllHeaderLines();
        while (e.hasMoreElements()) {
            size += (long)((String)e.nextElement()).length();
        }
        return size;
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public void setMessage(MimeMessage message) {
        this.message = message;
    }

    public void setRecipients(Collection recipients) {
        this.recipients = recipients;
    }

    public void setSender(MailAddress sender) {
        this.sender = sender;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setLastUpdated(Date lastUpdated) {
        if (lastUpdated != null) {
            lastUpdated = new Date(lastUpdated.getTime());
        }
        this.lastUpdated = lastUpdated;
    }

    public void writeMessageTo(OutputStream out) throws IOException, MessagingException {
        if (this.message == null) {
            throw new MessagingException("No message set for this MailImpl.");
        }
        this.message.writeTo(out);
    }

    public Mail bounce(String bounceText) throws MessagingException {
        MimeMessage original = this.getMessage();
        MimeMessage reply = (MimeMessage)original.reply(false);
        reply.setSubject("Re: " + original.getSubject());
        HashSet<MailAddress> recipients = new HashSet<MailAddress>();
        recipients.add(this.getSender());
        InternetAddress[] addr = new InternetAddress[]{new InternetAddress(this.getSender().toString())};
        reply.setRecipients(Message.RecipientType.TO, (Address[])addr);
        reply.setFrom((Address)new InternetAddress(this.getRecipients().iterator().next().toString()));
        reply.setText(bounceText);
        reply.setHeader("Message-ID", "replyTo-" + this.getName());
        return new MailImpl("replyTo-" + this.getName(), new MailAddress(this.getRecipients().iterator().next().toString()), recipients, reply);
    }

    public void writeContentTo(OutputStream out, int lines) throws IOException, MessagingException {
        if (this.message != null) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(this.message.getInputStream()));
            while (lines-- > 0 && (line = br.readLine()) != null) {
                line = line + "\r\n";
                out.write(line.getBytes());
            }
        } else {
            throw new MessagingException("No message set for this MailImpl.");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Object obj = in.readObject();
            if (obj == null) {
                this.sender = null;
            } else if (obj instanceof String) {
                this.sender = new MailAddress((String)obj);
            } else if (obj instanceof MailAddress) {
                this.sender = (MailAddress)obj;
            }
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing sender address: " + pe.getMessage());
        }
        this.recipients = (Collection)in.readObject();
        this.state = (String)in.readObject();
        this.errorMessage = (String)in.readObject();
        this.name = (String)in.readObject();
        this.remoteHost = (String)in.readObject();
        this.remoteAddr = (String)in.readObject();
        this.setLastUpdated((Date)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.lastUpdated = new Date();
        out.writeObject(this.sender);
        out.writeObject(this.recipients);
        out.writeObject(this.state);
        out.writeObject(this.errorMessage);
        out.writeObject(this.name);
        out.writeObject(this.remoteHost);
        out.writeObject(this.remoteAddr);
        out.writeObject(this.lastUpdated);
    }

    public void dispose() {
    }
}

