/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.image;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.engine.image.ImageCaptchaEngine;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.ImageCaptchaFactory;
import java.util.Locale;
import java.util.Random;

public abstract class DefaultImageCaptchaEngine
extends ImageCaptchaEngine {
    private ImageCaptchaFactory[] factories;
    private Random myRandom = new Random();

    public DefaultImageCaptchaEngine(ImageCaptchaFactory[] factories) {
        this.factories = factories;
        if (factories == null || factories.length == 0) {
            throw new CaptchaException("DefaultImageCaptchaEngine cannot be constructed with a null or empty factories array");
        }
    }

    public final ImageCaptchaFactory getImageCaptchaFactory() {
        return this.factories[this.myRandom.nextInt(this.factories.length)];
    }

    public final ImageCaptcha getNextImageCaptcha() {
        return this.getImageCaptchaFactory().getImageCaptcha();
    }

    public ImageCaptcha getNextImageCaptcha(Locale locale) {
        return this.getImageCaptchaFactory().getImageCaptcha(locale);
    }
}

