/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.sound.utils;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.sound.utils.Sound;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class StringToSound {
    protected String bundle;
    protected TreeMap list;
    static /* synthetic */ Class class$com$octo$captcha$component$sound$utils$StringToSound;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public StringToSound(String thebundle) {
        this.bundle = thebundle;
        this.generateAlphabetSoundList();
    }

    public Sound getSound(String word) {
        char[] characters = word.toCharArray();
        Sound result = null;
        try {
            String firstToken = (String)this.list.get(String.valueOf(characters[1]));
            AudioInputStream ais = this.getAudioInputStream(firstToken);
            SourceDataLine line = this.getLine(ais);
            AudioInputStream[] listais = new AudioInputStream[characters.length];
            int i = 0;
            while (i < characters.length) {
                String token = (String)this.list.get(String.valueOf(characters[i]));
                if (token != null) {
                    listais[i] = this.getAudioInputStream(token);
                }
                ++i;
            }
            result = new Sound(line, listais);
        }
        catch (Exception e) {
            throw new CaptchaException(e);
        }
        return result;
    }

    protected AudioInputStream getAudioInputStream(String fileName) throws UnsupportedAudioFileException, IOException {
        InputStream is = (class$com$octo$captcha$component$sound$utils$StringToSound == null ? (class$com$octo$captcha$component$sound$utils$StringToSound = StringToSound.class$("com.octo.captcha.component.sound.utils.StringToSound")) : class$com$octo$captcha$component$sound$utils$StringToSound).getResourceAsStream("/" + fileName);
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(is);
        return audioInputStream;
    }

    protected SourceDataLine getLine(AudioInputStream audioInputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        AudioFormat audioFormat1 = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = StringToSound.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat1);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(audioFormat1);
        return line;
    }

    protected void generateAlphabetSoundList() {
        this.list = new TreeMap();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.bundle);
        Enumeration<String> words = resourceBundle.getKeys();
        while (words.hasMoreElements()) {
            String line = words.nextElement();
            StringTokenizer token = new StringTokenizer(line, ";");
            this.list.put(token.nextToken(), token.nextToken());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

