/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.backgroundgenerator;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.backgroundgenerator.AbstractBackgroundGenerator;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FileReaderRandomBackgroundGenerator
extends AbstractBackgroundGenerator {
    private List images = new ArrayList();
    private String rootPath = ".";
    static /* synthetic */ Class class$com$octo$captcha$component$image$backgroundgenerator$FileReaderRandomBackgroundGenerator;

    public FileReaderRandomBackgroundGenerator(Integer width, Integer height, String rootPath) {
        super(width, height);
        File dir;
        File[] files;
        if (rootPath != null) {
            this.rootPath = rootPath;
        }
        if ((files = (dir = this.findDirectory(this.rootPath)).listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                BufferedImage out = null;
                if (file.isFile()) {
                    out = FileReaderRandomBackgroundGenerator.getImage(file);
                }
                if (out != null) {
                    this.images.add(this.images.size(), out);
                }
                ++i;
            }
            if (this.images.size() != 0) {
                int i2 = 0;
                while (i2 < this.images.size()) {
                    BufferedImage bufferedImage = (BufferedImage)this.images.get(i2);
                    this.images.set(i2, this.tile(bufferedImage));
                    ++i2;
                }
            } else {
                throw new CaptchaException("Root path directory is valid but does not contains any image (jpg) files");
            }
        }
    }

    protected File findDirectory(String rootPath) {
        File dir = new File(rootPath);
        StringBuffer triedPath = new StringBuffer();
        this.appendFilePath(triedPath, dir);
        if (!dir.canRead() || !dir.isDirectory()) {
            dir = new File(".", rootPath);
            this.appendFilePath(triedPath, dir);
            if (!dir.canRead() || !dir.isDirectory()) {
                dir = new File("/", rootPath);
                this.appendFilePath(triedPath, dir);
                if (!dir.canRead() || !dir.isDirectory()) {
                    URL url = (class$com$octo$captcha$component$image$backgroundgenerator$FileReaderRandomBackgroundGenerator == null ? (class$com$octo$captcha$component$image$backgroundgenerator$FileReaderRandomBackgroundGenerator = FileReaderRandomBackgroundGenerator.class$("com.octo.captcha.component.image.backgroundgenerator.FileReaderRandomBackgroundGenerator")) : class$com$octo$captcha$component$image$backgroundgenerator$FileReaderRandomBackgroundGenerator).getClassLoader().getResource(rootPath);
                    if (url != null) {
                        dir = new File(url.getFile());
                        this.appendFilePath(triedPath, dir);
                    } else {
                        url = ClassLoader.getSystemClassLoader().getResource(rootPath);
                        if (url != null) {
                            dir = new File(url.getFile());
                            this.appendFilePath(triedPath, dir);
                        }
                    }
                }
            }
        }
        StringTokenizer token = this.getClasspathFromSystemProperty();
        while (token.hasMoreElements()) {
            String path = token.nextToken();
            if (path.endsWith(".jar")) continue;
            dir = new File(path, rootPath);
            this.appendFilePath(triedPath, dir);
            if (dir.canRead() && dir.isDirectory()) break;
        }
        if (!dir.canRead() || !dir.isDirectory()) {
            throw new CaptchaException("All tried paths :'" + triedPath.toString() + "' is not" + " a directory or cannot be read");
        }
        return dir;
    }

    private StringTokenizer getClasspathFromSystemProperty() {
        String classpath = System.getProperty("java.class.path");
        StringTokenizer token = new StringTokenizer(classpath, File.pathSeparator);
        return token;
    }

    private void appendFilePath(StringBuffer triedPath, File dir) {
        triedPath.append(dir.getAbsolutePath());
        triedPath.append("\n");
    }

    private BufferedImage tile(BufferedImage tileImage) {
        BufferedImage image = new BufferedImage(this.getImageWidth(), this.getImageHeight(), tileImage.getType());
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        int NumberX = this.getImageWidth() / tileImage.getWidth();
        int NumberY = this.getImageHeight() / tileImage.getHeight();
        int k = 0;
        while (k <= NumberY) {
            int l = 0;
            while (l <= NumberX) {
                g2.drawImage(tileImage, l * tileImage.getWidth(), k * tileImage.getHeight(), Math.min(tileImage.getWidth(), this.getImageWidth()), Math.min(tileImage.getHeight(), this.getImageHeight()), null);
                ++l;
            }
            ++k;
        }
        g2.dispose();
        return image;
    }

    private static BufferedImage getImage(File o) {
        BufferedImage out = null;
        try {
            FileInputStream fis = new FileInputStream(o);
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)fis);
            out = decoder.decodeAsBufferedImage();
            fis.close();
            return out;
        }
        catch (IOException e) {
            throw new CaptchaException("Unknown error during file reading ", e);
        }
        catch (ImageFormatException e) {
            return null;
        }
    }

    public BufferedImage getBackround() {
        return (BufferedImage)this.images.get(this.myRandom.nextInt(this.images.size()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

