/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import org.fest.swing.util.AWT;

final class WindowMetrics {
    private final Window window;
    final Insets insets;

    WindowMetrics(Window w) {
        this.window = w;
        this.insets = AWT.insetsFrom(w);
    }

    Point center() {
        int x = this.window.getX() + this.insets.left + this.centerWidth();
        int y = this.window.getY() + this.insets.top + this.centerHeight();
        return new Point(x, y);
    }

    private int centerWidth() {
        return (this.window.getWidth() - this.verticalInsets()) / 2;
    }

    int verticalInsets() {
        return this.insets.left + this.insets.right;
    }

    private int centerHeight() {
        return (this.window.getHeight() - this.horizontalInsets()) / 2;
    }

    int horizontalInsets() {
        return this.insets.top + this.insets.bottom;
    }
}

