/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.EmptyStackException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.fest.swing.input.DragAwareEventQueue;
import org.fest.swing.input.EventNormalizer;
import org.fest.swing.input.PushEventQueueTask;

class DragAwareEventNormalizer
extends EventNormalizer {
    private static Logger logger = Logger.getLogger(DragAwareEventNormalizer.class.getName());
    private DragAwareEventQueue dragAwareEventQueue;

    DragAwareEventNormalizer() {
    }

    void startListening(Toolkit toolkit, AWTEventListener delegate, long mask) {
        super.startListening(toolkit, delegate, mask);
        try {
            this.dragAwareEventQueue = this.createDragAwareEventQueue(toolkit, mask);
            SwingUtilities.invokeAndWait(new PushEventQueueTask(toolkit, this.dragAwareEventQueue));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Ignoring error at EventNormalizer startup", e);
        }
    }

    DragAwareEventQueue createDragAwareEventQueue(Toolkit toolkit, long mask) {
        return new DragAwareEventQueue(toolkit, mask, this);
    }

    void stopListening() {
        this.disposeDragAwareEventQueue();
        super.stopListening();
    }

    private void disposeDragAwareEventQueue() {
        if (this.dragAwareEventQueue == null) {
            return;
        }
        try {
            this.dragAwareEventQueue.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        this.dragAwareEventQueue = null;
    }
}

