/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JLabel;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.JLabelDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.TextDisplayFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLabelFixture
extends JPopupMenuInvokerFixture<JLabel>
implements CommonComponentFixture,
TextDisplayFixture {
    private JLabelDriver driver;

    public JLabelFixture(Robot robot, JLabel target) {
        super(robot, target);
        this.createDriver();
    }

    public JLabelFixture(Robot robot, String labelName) {
        super(robot, labelName, JLabel.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JLabelDriver(this.robot));
    }

    final void updateDriver(JLabelDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public JLabelFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JLabelFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JLabelFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JLabelFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JLabelFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JLabelFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JLabelFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JLabelFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JLabelFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JLabelFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JLabelFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JLabelFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JLabelFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JLabelFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JLabelFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public String text() {
        return ((JLabel)this.target).getText();
    }

    @Override
    public JLabelFixture requireText(String expected) {
        this.driver.requireText((JLabel)this.target, expected);
        return this;
    }
}

