/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.DialogDriver;
import org.fest.swing.fixture.WindowFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogFixture
extends WindowFixture<Dialog> {
    private DialogDriver driver;

    public DialogFixture(Dialog target) {
        super(target);
        this.createDriver();
    }

    public DialogFixture(Robot robot, Dialog target) {
        super(robot, target);
        this.createDriver();
    }

    public DialogFixture(Robot robot, String dialogName) {
        super(robot, dialogName, Dialog.class);
        this.createDriver();
    }

    public DialogFixture(String dialogName) {
        super(dialogName, Dialog.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new DialogDriver(this.robot));
    }

    void updateDriver(DialogDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public DialogFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public DialogFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public DialogFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public DialogFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public DialogFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public DialogFixture moveTo(Point p) {
        this.driver.moveTo((Window)this.target, p);
        return this;
    }

    @Override
    public DialogFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public DialogFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public DialogFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public DialogFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public DialogFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public DialogFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public DialogFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    public DialogFixture requireModal() {
        this.driver.requireModal((Dialog)this.target);
        return this;
    }

    @Override
    public DialogFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public DialogFixture requireSize(Dimension size) {
        this.driver.requireSize(this.target, size);
        return this;
    }

    @Override
    public DialogFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public DialogFixture resizeHeightTo(int height) {
        this.driver.resizeHeightTo((Window)this.target, height);
        return this;
    }

    @Override
    public DialogFixture resizeTo(Dimension size) {
        this.driver.resizeTo((Window)this.target, size);
        return this;
    }

    @Override
    public DialogFixture resizeWidthTo(int width) {
        this.driver.resizeWidthTo((Window)this.target, width);
        return this;
    }

    @Override
    public DialogFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    public DialogFixture show() {
        this.driver.show((Window)this.target);
        return this;
    }

    public DialogFixture show(Dimension size) {
        this.driver.show((Window)this.target, size);
        return this;
    }

    @Override
    public void close() {
        this.driver.close((Window)this.target);
    }
}

