/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JTabbedPane;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTabbedPaneLocation;
import org.fest.swing.exception.LocationUnavailableException;

public class JTabbedPaneDriver
extends JComponentDriver {
    private final JTabbedPaneLocation location;

    public JTabbedPaneDriver(Robot robot) {
        this(robot, new JTabbedPaneLocation());
    }

    JTabbedPaneDriver(Robot robot, JTabbedPaneLocation location) {
        super(robot);
        this.location = location;
    }

    public String[] tabTitles(JTabbedPane tabbedPane) {
        int count = tabbedPane.getTabCount();
        String[] titles = new String[count];
        for (int i = 0; i < count; ++i) {
            titles[i] = tabbedPane.getTitleAt(i);
        }
        return titles;
    }

    public void selectTab(JTabbedPane tabbedPane, String title) {
        if (!tabbedPane.isEnabled()) {
            return;
        }
        int index = this.location.indexOf(tabbedPane, title);
        this.selectTab(tabbedPane, index);
    }

    public void selectTab(JTabbedPane tabbedPane, int index) {
        if (!tabbedPane.isEnabled()) {
            return;
        }
        try {
            Point p = this.location.pointAt(tabbedPane, index);
            this.click((Component)tabbedPane, p);
        }
        catch (LocationUnavailableException e) {
            this.setTabDirectly(tabbedPane, index);
        }
    }

    void setTabDirectly(JTabbedPane tabbedPane, int index) {
        this.robot.invokeAndWait(new SetSelectedIndexTask(tabbedPane, index));
    }

    private static class SetSelectedIndexTask
    implements Runnable {
        private final JTabbedPane target;
        private final int index;

        SetSelectedIndexTask(JTabbedPane target, int index) {
            this.target = target;
            this.index = index;
        }

        public void run() {
            this.target.setSelectedIndex(this.index);
        }
    }
}

