/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTextComponentDriver;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class JSpinnerDriver
extends JComponentDriver {
    private static final String VALUE_PROPERTY = "value";
    private final JTextComponentDriver textComponentDriver;

    public JSpinnerDriver(Robot robot) {
        super(robot);
        this.textComponentDriver = new JTextComponentDriver(robot);
    }

    public void increment(JSpinner spinner, int times) {
        this.validate(times, "increment the value");
        for (int i = 0; i < times; ++i) {
            this.increment(spinner);
        }
    }

    public void increment(JSpinner spinner) {
        this.pressKey(spinner, 38);
    }

    public void decrement(JSpinner spinner, int times) {
        this.validate(times, "decrement the value");
        for (int i = 0; i < times; ++i) {
            this.decrement(spinner);
        }
    }

    private void validate(int times, String action) {
        if (times > 0) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The number of times to ", action, " should be greater than zero, but was <", String.valueOf(times), ">"}));
    }

    public void decrement(JSpinner spinner) {
        this.pressKey(spinner, 40);
    }

    private void pressKey(JSpinner spinner, int key) {
        if (!spinner.isEnabled()) {
            return;
        }
        this.focus(spinner);
        this.robot.pressAndReleaseKeys(key);
    }

    public void enterText(JSpinner spinner, String text) {
        if (!spinner.isEnabled()) {
            return;
        }
        try {
            JTextComponent editor = this.robot.finder().findByType(spinner, JTextComponent.class);
            this.textComponentDriver.replaceText(editor, text);
            this.robot.pressAndReleaseKeys(10);
        }
        catch (ComponentLookupException e) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find editor for ", Formatting.format(spinner)}));
        }
    }

    public void requireValue(JSpinner spinner, Object value) {
        Assertions.assertThat((Object)spinner.getValue()).as(JSpinnerDriver.propertyName(spinner, VALUE_PROPERTY)).isEqualTo(value);
    }
}

