/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Insets;
import java.awt.Point;
import javax.swing.JSlider;
import org.fest.swing.util.AWT;

public final class JSliderLocation {
    public Point pointAt(JSlider slider, int value) {
        if (slider.getOrientation() == 1) {
            return this.locationForVerticalOrientation(slider, value);
        }
        return this.locationForHorizontalOrientation(slider, value);
    }

    private Point locationForVerticalOrientation(JSlider slider, int value) {
        Point p = AWT.centerOf(slider);
        Insets insets = slider.getInsets();
        int max = slider.getHeight() - insets.top - insets.bottom - 1;
        p.y = (int)(this.percent(slider, value) * (float)max);
        if (!slider.getInverted()) {
            p.y = max - p.y;
        }
        return p;
    }

    private Point locationForHorizontalOrientation(JSlider slider, int value) {
        Point p = AWT.centerOf(slider);
        Insets insets = slider.getInsets();
        int max = slider.getWidth() - insets.left - insets.right - 1;
        p.x = (int)(this.percent(slider, value) * (float)max);
        if (slider.getInverted()) {
            p.x = max - p.x;
        }
        return p;
    }

    private float percent(JSlider slider, int value) {
        return (float)(value - slider.getMinimum()) / (float)this.range(slider);
    }

    private int range(JSlider slider) {
        return slider.getMaximum() - slider.getMinimum();
    }
}

