/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.core.WindowAncestorFinder;
import org.fest.swing.driver.ClickButtonTask;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JMenuItemLocation;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Platform;
import org.fest.util.Strings;

public class JMenuItemDriver
extends JComponentDriver {
    private static final int SUBMENU_DELAY = Platform.isOSX() ? 100 : 0;

    public JMenuItemDriver(Robot robot) {
        super(robot);
    }

    private void show(JMenuItem menuItem) {
        JMenuItemLocation location = new JMenuItemLocation(menuItem);
        this.activateParentIfIsAMenu(location);
        this.moveParentWindowToFront(location);
        if (menuItem instanceof JMenu && !location.inMenuBar()) {
            this.waitForSubMenuToShow();
        }
    }

    private void activateParentIfIsAMenu(JMenuItemLocation location) {
        if (!location.isParentAMenu()) {
            return;
        }
        this.click((JMenuItem)location.parentOrInvoker());
    }

    public void click(JMenuItem menuItem) {
        this.show(menuItem);
        this.doClick(menuItem);
        this.ensurePopupIsShowing(menuItem);
    }

    private void ensurePopupIsShowing(JMenuItem menuItem) {
        if (!(menuItem instanceof JMenu)) {
            return;
        }
        JPopupMenu popup = ((JMenu)menuItem).getPopupMenu();
        if (!this.waitForShowing(popup, this.robot.settings().timeoutToFindPopup())) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Clicking on menu item <", Formatting.format(menuItem), "> never showed a pop-up menu"}));
        }
        this.waitForSubMenuToShow();
    }

    private void moveParentWindowToFront(JMenuItemLocation location) {
        if (!location.inMenuBar()) {
            return;
        }
        this.moveToFront(WindowAncestorFinder.ancestorOf(location.parentOrInvoker()));
    }

    private void moveToFront(Window w) {
        if (w == null) {
            return;
        }
        this.robot.invokeAndWait(w, new MoveToFrontTask(w));
        this.robot.moveMouse(w);
    }

    private void waitForSubMenuToShow() {
        int delayBetweenEvents = this.robot.settings().delayBetweenEvents();
        if (SUBMENU_DELAY > delayBetweenEvents) {
            Pause.pause(SUBMENU_DELAY - delayBetweenEvents);
        }
    }

    private void doClick(JMenuItem menuItem) {
        if (!menuItem.isEnabled()) {
            ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Menu item <", Formatting.format(menuItem), "> is disabled"}));
        }
        if (this.isMacOSMenuBar()) {
            this.clickMenuInMacOSMenuBar(menuItem);
            return;
        }
        super.click(menuItem);
        this.robot.waitForIdle();
    }

    private boolean isMacOSMenuBar() {
        return Platform.isOSX() && (Boolean.getBoolean("apple.laf.useScreenMenuBar") || Boolean.getBoolean("com.apple.macos.useScreenMenuBar"));
    }

    private void clickMenuInMacOSMenuBar(JMenuItem menuItem) {
        this.robot.invokeAndWait(new ClickButtonTask(menuItem));
    }

    private static class MoveToFrontTask
    implements Runnable {
        private final Window target;

        MoveToFrontTask(Window target) {
            this.target = target;
        }

        public void run() {
            this.target.toFront();
        }
    }
}

