/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Condition;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.ComponentEnabledCondition;
import org.fest.swing.driver.DragAndDrop;
import org.fest.swing.driver.PerformDefaultAccessibleActionTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Platform;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Strings;

public class ComponentDriver {
    private static final String ENABLED_PROPERTY = "enabled";
    private static final String SIZE_PROPERTY = "size";
    private static final String VISIBLE_PROPERTY = "visible";
    protected final Robot robot;
    private final DragAndDrop dragAndDrop;

    public ComponentDriver(Robot robot) {
        this(robot, new DragAndDrop(robot));
    }

    ComponentDriver(Robot robot, DragAndDrop dragAndDrop) {
        this.robot = robot;
        this.dragAndDrop = dragAndDrop;
    }

    public void click(Component c) {
        this.robot.click(c);
    }

    public void click(Component c, MouseButton button) {
        this.robot.click(c, button);
    }

    public void click(Component c, MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            throw new NullPointerException("The given MouseClickInfo should not be null");
        }
        this.click(c, mouseClickInfo.button(), mouseClickInfo.times());
    }

    public void doubleClick(Component c) {
        this.robot.doubleClick(c);
    }

    public void rightClick(Component c) {
        this.robot.rightClick(c);
    }

    public void click(Component c, MouseButton button, int times) {
        this.robot.click(c, button, times);
    }

    public void click(Component target, Point where) {
        this.robot.click(target, where);
    }

    public void focusAndWaitForFocusGain(Component c) {
        this.robot.focusAndWaitForFocusGain(c);
    }

    protected Settings settings() {
        return this.robot.settings();
    }

    public void requireSize(Component c, Dimension size) {
        Assertions.assertThat((Object)c.getSize()).as(ComponentDriver.propertyName(c, SIZE_PROPERTY)).isEqualTo((Object)size);
    }

    public void requireVisible(Component c) {
        Assertions.assertThat((boolean)c.isVisible()).as(ComponentDriver.visibleProperty(c)).isTrue();
    }

    public void requireNotVisible(Component c) {
        Assertions.assertThat((boolean)c.isVisible()).as(ComponentDriver.visibleProperty(c)).isFalse();
    }

    private static String visibleProperty(Component c) {
        return ComponentDriver.propertyName(c, VISIBLE_PROPERTY);
    }

    public void requireEnabled(Component c) {
        Assertions.assertThat((boolean)c.isEnabled()).as(ComponentDriver.enabledProperty(c)).isTrue();
    }

    public void requireEnabled(Component c, Timeout timeout) {
        Pause.pause((Condition)new ComponentEnabledCondition(c), timeout);
    }

    public void requireDisabled(Component c) {
        Assertions.assertThat((boolean)c.isEnabled()).as(ComponentDriver.enabledProperty(c)).isFalse();
    }

    private static String enabledProperty(Component c) {
        return ComponentDriver.propertyName(c, ENABLED_PROPERTY);
    }

    public void pressAndReleaseKeys(Component c, int ... keyCodes) {
        if (keyCodes == null) {
            throw new NullPointerException("The array of key codes should not be null");
        }
        this.focus(c);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    public void pressAndReleaseKey(Component c, KeyPressInfo keyPressInfo) {
        if (keyPressInfo == null) {
            throw new NullPointerException("The given KeyPressInfo should not be null");
        }
        this.pressAndReleaseKey(c, keyPressInfo.keyCode(), keyPressInfo.modifiers());
    }

    public void pressAndReleaseKey(Component c, int keyCode, int[] modifiers) {
        this.focus(c);
        this.robot.pressAndReleaseKey(keyCode, modifiers);
    }

    public void pressKey(Component c, int keyCode) {
        this.focus(c);
        this.robot.pressKey(keyCode);
    }

    public void releaseKey(Component c, int keyCode) {
        this.focus(c);
        this.robot.releaseKey(keyCode);
    }

    public void focus(Component c) {
        this.robot.focus(c);
    }

    protected final void drag(Component c, Point where) {
        this.dragAndDrop.drag(c, where);
    }

    protected final void drop(Component c, Point where) {
        this.dragAndDrop.drop(c, where);
    }

    protected final void dragOver(Component c, Point where) {
        this.dragAndDrop.dragOver(c, where);
    }

    protected final boolean isUserResizable(Component c) {
        if (c instanceof Dialog) {
            return ((Dialog)c).isResizable();
        }
        if (c instanceof Frame) {
            return ((Frame)c).isResizable();
        }
        return Platform.canResizeWindows();
    }

    protected final boolean isUserMovable(Component c) {
        return c instanceof Dialog || c instanceof Frame || Platform.canMoveWindows();
    }

    protected final void performAccessibleActionOf(Component c) {
        this.robot.invokeLater(c, new PerformDefaultAccessibleActionTask(c));
    }

    protected final boolean waitForShowing(Component c, long timeout) {
        if (this.robot.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.robot.isReadyForInput(c)) {
            Component invoker;
            if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                this.robot.jitter(invoker);
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    public static String propertyName(Component c, String propertyName) {
        return Strings.concat((Object[])new Object[]{Formatting.format(c), " - property:", Strings.quote((String)propertyName)});
    }
}

