/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.driver.BaseValueReader;
import org.fest.swing.driver.BasicJComboBoxCellReader;

public class BasicJTableCellReader
extends BaseValueReader
implements JTableCellReader {
    private final JComboBoxCellReader comboBoxCellValueReader = new BasicJComboBoxCellReader();

    public String valueAt(JTable table, int row, int column) {
        Component c = this.cellRendererComponent(table, row, column);
        if (c instanceof JLabel) {
            return ((JLabel)c).getText();
        }
        if (c instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)c).isSelected());
        }
        if (c instanceof JComboBox) {
            return this.valueAt((JComboBox)c);
        }
        return this.valueFrom(this.cellAt(table, row, column));
    }

    private String valueAt(JComboBox comboBox) {
        int selectedIndex = comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return this.comboBoxCellValueReader.valueAt(comboBox, selectedIndex);
    }

    public Font fontAt(JTable table, int row, int column) {
        return this.cellRendererComponent(table, row, column).getFont();
    }

    public Color backgroundAt(JTable table, int row, int column) {
        return this.cellRendererComponent(table, row, column).getBackground();
    }

    public Color foregroundAt(JTable table, int row, int column) {
        return this.cellRendererComponent(table, row, column).getForeground();
    }

    protected final Component cellRendererComponent(JTable table, int row, int column) {
        Object value = this.cellAt(table, row, column);
        TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
        boolean cellSelected = table.isCellSelected(row, column);
        return cellRenderer.getTableCellRendererComponent(table, value, cellSelected, false, row, column);
    }

    private Object cellAt(JTable table, int row, int column) {
        return table.getModel().getValueAt(row, column);
    }
}

