/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.Condition;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectAssert
extends GenericAssert<Object> {
    ObjectAssert(Object actual) {
        super(actual);
    }

    public ObjectAssert isInstanceOf(Class<?> type) {
        this.isNotNull();
        this.validateTypeToCheckAgainst(type);
        Class<?> current = this.actual.getClass();
        if (!type.isAssignableFrom(current)) {
            this.fail(Strings.concat((Object[])new Object[]{"expected instance of:", Formatting.inBrackets(type), " but was instance of:", Formatting.inBrackets(current)}));
        }
        return this;
    }

    public ObjectAssert isInstanceOfAny(Class<?> ... types) {
        this.isNotNull();
        if (types == null) {
            throw new IllegalArgumentException("The given array of types to check against should not be null");
        }
        if (!this.foundInstanceOfAny(types)) {
            this.fail(Strings.concat((Object[])new Object[]{"expected instance of any:<", this.typeNames(types), "> but was instance of:", Formatting.inBrackets(this.actual.getClass())}));
        }
        return this;
    }

    private boolean foundInstanceOfAny(Class<?> ... types) {
        Class<?> current = this.actual.getClass();
        for (Class<?> type : types) {
            this.validateTypeToCheckAgainst(type);
            if (!type.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    void validateTypeToCheckAgainst(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("The given type to check against should not be null");
        }
    }

    private String typeNames(Class<?> ... types) {
        return Arrays.toString(Objects.namesOf((Class[])types));
    }

    public ObjectAssert as(String description) {
        this.description(description);
        return this;
    }

    public ObjectAssert describedAs(String description) {
        return this.as(description);
    }

    public ObjectAssert satisfies(Condition<Object> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ObjectAssert doesNotSatisfy(Condition<Object> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ObjectAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ObjectAssert isSameAs(Object expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ObjectAssert isNotSameAs(Object other) {
        this.assertNotSameAs(other);
        return this;
    }

    public ObjectAssert isEqualTo(Object expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ObjectAssert isNotEqualTo(Object other) {
        this.assertNotEqualTo(other);
        return this;
    }
}

