/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatArrayAssert
extends ArrayAssert<float[]> {
    FloatArrayAssert(float ... actual) {
        super(actual);
    }

    public FloatArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public FloatArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public FloatArrayAssert contains(float ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public FloatArrayAssert containsOnly(float ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public FloatArrayAssert excludes(float ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((float[])this.actual);
    }

    private List<Object> list(float[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (float value : values) {
            list.add(Float.valueOf(value));
        }
        return list;
    }

    public FloatArrayAssert satisfies(Condition<float[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public FloatArrayAssert doesNotSatisfy(Condition<float[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public FloatArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public FloatArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public FloatArrayAssert isEqualTo(float[] expected) {
        if (!Arrays.equals((float[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public FloatArrayAssert isNotEqualTo(float[] array) {
        if (Arrays.equals((float[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public FloatArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((float[])this.actual).length;
    }

    public FloatArrayAssert isSameAs(float[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public FloatArrayAssert isNotSameAs(float[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

