/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.fest.util.Closeables;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileContentComparator {
    private static final String EOF = "EOF";

    FileContentComparator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineDiff[] compareContents(File actual, File expected) throws IOException {
        LineDiff[] lineDiffArray;
        FileInputStream actualInputStream = null;
        FileInputStream expectedInputStream = null;
        try {
            actualInputStream = new FileInputStream(actual);
            expectedInputStream = new FileInputStream(expected);
            List<LineDiff> diffs = this.checkSameContent(this.reader(actualInputStream), this.reader(expectedInputStream));
            lineDiffArray = diffs.toArray(new LineDiff[diffs.size()]);
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable[])new Closeable[]{expectedInputStream});
            Closeables.close((Closeable[])new Closeable[]{actualInputStream});
            throw throwable;
        }
        Closeables.close((Closeable[])new Closeable[]{expectedInputStream});
        Closeables.close((Closeable[])new Closeable[]{actualInputStream});
        return lineDiffArray;
    }

    private LineNumberReader reader(InputStream inputStream) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
    }

    private List<LineDiff> checkSameContent(LineNumberReader actual, LineNumberReader expected) throws IOException {
        String actualLine;
        int lineNumber;
        ArrayList<LineDiff> diffs = new ArrayList<LineDiff>();
        while (true) {
            String expectedLine;
            if (!expected.ready() && !actual.ready()) {
                return diffs;
            }
            lineNumber = expected.getLineNumber();
            actualLine = actual.readLine();
            if (Objects.areEqual((Object)actualLine, (Object)(expectedLine = expected.readLine()))) continue;
            diffs.add(new LineDiff(lineNumber, actualLine, expectedLine));
            if (!actual.ready() && expected.ready()) {
                diffs.add(new LineDiff(lineNumber, EOF, expectedLine));
                return diffs;
            }
            if (actual.ready() && !expected.ready()) break;
        }
        diffs.add(new LineDiff(lineNumber, actualLine, EOF));
        return diffs;
    }

    static class LineDiff {
        final int lineNumber;
        final String actual;
        final String expected;

        LineDiff(int lineNumber, String actual, String expected) {
            this.lineNumber = lineNumber;
            this.actual = actual;
            this.expected = expected;
        }
    }
}

