/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleArrayAssert
extends ArrayAssert<double[]> {
    DoubleArrayAssert(double ... actual) {
        super(actual);
    }

    public DoubleArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public DoubleArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public DoubleArrayAssert contains(double ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public DoubleArrayAssert containsOnly(double ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public DoubleArrayAssert excludes(double ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((double[])this.actual);
    }

    private List<Object> list(double[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (double value : values) {
            list.add(value);
        }
        return list;
    }

    public DoubleArrayAssert satisfies(Condition<double[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public DoubleArrayAssert doesNotSatisfy(Condition<double[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public DoubleArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public DoubleArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public DoubleArrayAssert isEqualTo(double[] expected) {
        if (!Arrays.equals((double[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public DoubleArrayAssert isNotEqualTo(double[] array) {
        if (Arrays.equals((double[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public DoubleArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((double[])this.actual).length;
    }

    public DoubleArrayAssert isSameAs(double[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public DoubleArrayAssert isNotSameAs(double[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

