/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.math.BigDecimal;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;
import org.fest.assertions.GenericAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigDecimalAssert
extends GenericAssert<BigDecimal> {
    BigDecimalAssert(BigDecimal actual) {
        super(actual);
    }

    public BigDecimalAssert as(String description) {
        this.description(description);
        return this;
    }

    public BigDecimalAssert describedAs(String description) {
        return this.as(description);
    }

    public BigDecimalAssert satisfies(Condition<BigDecimal> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public BigDecimalAssert doesNotSatisfy(Condition<BigDecimal> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public BigDecimalAssert isPositive() {
        return this.isGreaterThan(BigDecimal.ZERO);
    }

    public BigDecimalAssert isNegative() {
        return this.isLessThan(BigDecimal.ZERO);
    }

    public BigDecimalAssert isZero() {
        return this.isEqualByComparingTo(BigDecimal.ZERO);
    }

    public BigDecimalAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public BigDecimalAssert isSameAs(BigDecimal expected) {
        this.assertSameAs(expected);
        return this;
    }

    public BigDecimalAssert isNotSameAs(BigDecimal other) {
        this.assertNotSameAs(other);
        return this;
    }

    public BigDecimalAssert isEqualTo(BigDecimal expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public BigDecimalAssert isNotEqualTo(BigDecimal other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public BigDecimalAssert isEqualByComparingTo(BigDecimal expected) {
        this.isNotNull();
        if (((BigDecimal)this.actual).compareTo(expected) != 0) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public BigDecimalAssert isLessThan(BigDecimal value) {
        this.isNotNull();
        if (((BigDecimal)this.actual).compareTo(value) >= 0) {
            this.fail(Fail.errorMessageIfNotLessThan(this.actual, value));
        }
        return this;
    }

    public BigDecimalAssert isGreaterThan(BigDecimal value) {
        this.isNotNull();
        if (((BigDecimal)this.actual).compareTo(value) <= 0) {
            this.fail(Fail.errorMessageIfNotGreaterThan(this.actual, value));
        }
        return this;
    }

    public BigDecimalAssert isLessThanOrEqualTo(BigDecimal value) {
        this.isNotNull();
        if (((BigDecimal)this.actual).compareTo(value) > 0) {
            this.fail(Fail.errorMessageIfNotLessThanOrEqualTo(this.actual, value));
        }
        return this;
    }

    public BigDecimalAssert isGreaterThanOrEqualTo(BigDecimal value) {
        this.isNotNull();
        if (((BigDecimal)this.actual).compareTo(value) < 0) {
            this.fail(Fail.errorMessageIfNotGreaterThanOrEqualTo(this.actual, value));
        }
        return this;
    }
}

