/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;

public class ShortAssert
extends PrimitiveAssert {
    private static final short ZERO = 0;
    private final short actual;

    ShortAssert(short actual) {
        this.actual = actual;
    }

    public ShortAssert as(String description) {
        return (ShortAssert)this.description(description);
    }

    public ShortAssert describedAs(String description) {
        return this.as(description);
    }

    public ShortAssert isEqualTo(short expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public ShortAssert isNotEqualTo(short value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public ShortAssert isGreaterThan(short value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public ShortAssert isLessThan(short value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public ShortAssert isGreaterThanOrEqualTo(short value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public ShortAssert isLessThanOrEqualTo(short value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public ShortAssert isPositive() {
        return this.isGreaterThan((short)0);
    }

    public ShortAssert isNegative() {
        return this.isLessThan((short)0);
    }

    public ShortAssert isZero() {
        return this.isEqualTo((short)0);
    }
}

