/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fest.assertions.Condition;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Maps;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapAssert
extends GroupAssert<Map<?, ?>> {
    private static final String KEYS = "key(s)";
    private static final String VALUES = "value(s)";
    private static final String ENTRY = "entry";
    private static final String ENTRIES = "entries";

    MapAssert(Map<?, ?> actual) {
        super(actual);
    }

    public MapAssert as(String description) {
        this.description(description);
        return this;
    }

    public MapAssert describedAs(String description) {
        return this.as(description);
    }

    public MapAssert contains(Entry ... entries) {
        this.isNotNull();
        this.validate(ENTRIES, entries);
        ArrayList<Entry> notFound = new ArrayList<Entry>();
        for (Entry e : entries) {
            if (this.containsEntry(e)) continue;
            notFound.add(e);
        }
        if (!notFound.isEmpty()) {
            this.failIfNotFound(notFound.size() == 1 ? ENTRY : ENTRIES, notFound);
        }
        return this;
    }

    private boolean containsEntry(Entry e) {
        if (e == null) {
            throw new IllegalArgumentException("The entry to check should not be null");
        }
        if (!((Map)this.actual).containsKey(e.key)) {
            return false;
        }
        return ((Map)this.actual).containsValue(e.value);
    }

    public static Entry entry(Object key, Object value) {
        return new Entry(key, value);
    }

    public MapAssert keySetIncludes(Object ... keys) {
        this.isNotNull();
        this.validate("keys", keys);
        Set keySet = ((Map)this.actual).keySet();
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object key : keys) {
            if (keySet.contains(key)) continue;
            notFound.add(key);
        }
        if (!notFound.isEmpty()) {
            this.failIfNotFound(KEYS, notFound);
        }
        return this;
    }

    public MapAssert valuesInclude(Object ... values) {
        this.isNotNull();
        this.validate("values", values);
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object expected : values) {
            if (((Map)this.actual).containsValue(expected)) continue;
            notFound.add(expected);
        }
        if (!notFound.isEmpty()) {
            this.failIfNotFound(VALUES, notFound);
        }
        return this;
    }

    private void validate(String description, Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"The given array of ", description, " should not be null"}));
        }
    }

    private void failIfNotFound(String description, List<?> notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"the map:", this.formattedActual(), " does not contain the ", description, ":", Formatting.inBrackets(notFound)}));
    }

    public MapAssert hasSize(int expected) {
        this.isNotNull();
        int actualSize = this.actualGroupSize();
        if (actualSize != expected) {
            this.fail(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for map:", Formatting.inBrackets(this.actual)}));
        }
        return this;
    }

    @Override
    public final void isNullOrEmpty() {
        if (Maps.isEmpty((Map)((Map)this.actual))) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty map, but was:", this.formattedActual()}));
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (this.actual != null && !((Map)this.actual).isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"expecting empty map, but was:", this.formattedActual()}));
        }
    }

    private String formattedActual() {
        return Formatting.inBrackets(this.actual);
    }

    public MapAssert isEqualTo(Map<?, ?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public MapAssert isNotEmpty() {
        this.isNotNull();
        if (((Map)this.actual).isEmpty()) {
            this.fail("expecting non-empty map, but it was empty");
        }
        return this;
    }

    public MapAssert isNotEqualTo(Map<?, ?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public MapAssert isNotNull() {
        if (this.actual == null) {
            this.fail("expecting a non-null map, but it was null");
        }
        return this;
    }

    public MapAssert isNotSameAs(Map<?, ?> other) {
        this.assertNotSameAs(other);
        return this;
    }

    public MapAssert isSameAs(Map<?, ?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public MapAssert satisfies(Condition<Map<?, ?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public MapAssert doesNotSatisfy(Condition<Map<?, ?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((Map)this.actual).size();
    }

    public static class Entry {
        final Object key;
        final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return Strings.concat((Object[])new Object[]{Strings.quote((Object)this.key), "=", Strings.quote((Object)this.value)});
        }
    }
}

