/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;
import org.fest.util.Strings;

public final class FloatAssert
extends PrimitiveAssert {
    private static final float ZERO = 0.0f;
    private final float actual;

    FloatAssert(float actual) {
        this.actual = actual;
    }

    public FloatAssert as(String description) {
        return (FloatAssert)this.description(description);
    }

    public FloatAssert describedAs(String description) {
        return this.as(description);
    }

    public FloatAssert isEqualTo(float expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public FloatAssert isEqualTo(float expected, Delta delta) {
        if (Float.compare(expected, this.actual) == 0) {
            return this;
        }
        if (!(Math.abs(expected - this.actual) <= delta.value)) {
            this.fail(Strings.concat((Object[])new Object[]{Fail.errorMessageIfNotEqual(Float.valueOf(this.actual), Float.valueOf(expected)), " using delta:", Formatting.inBrackets(Float.valueOf(delta.value))}));
        }
        return this;
    }

    public FloatAssert isNotEqualTo(float value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public FloatAssert isGreaterThan(float value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public FloatAssert isLessThan(float value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public FloatAssert isGreaterThanOrEqualTo(float value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public FloatAssert isLessThanOrEqualTo(float value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public FloatAssert isNaN() {
        return this.isEqualTo(Float.NaN);
    }

    public FloatAssert isPositive() {
        return this.isGreaterThan(0.0f);
    }

    public FloatAssert isNegative() {
        return this.isLessThan(0.0f);
    }

    public FloatAssert isZero() {
        return this.isEqualTo(0.0f);
    }

    public static Delta delta(float d) {
        return new Delta(d);
    }

    public static class Delta {
        final float value;

        private Delta(float value) {
            this.value = value;
        }
    }
}

