/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharArrayAssert
extends ArrayAssert<char[]> {
    CharArrayAssert(char ... actual) {
        super(actual);
    }

    public CharArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public CharArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public CharArrayAssert contains(char ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public CharArrayAssert containsOnly(char ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public CharArrayAssert excludes(char ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((char[])this.actual);
    }

    private List<Object> list(char[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (char value : values) {
            list.add(Character.valueOf(value));
        }
        return list;
    }

    public CharArrayAssert satisfies(Condition<char[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public CharArrayAssert doesNotSatisfy(Condition<char[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public CharArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public CharArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public CharArrayAssert isEqualTo(char[] expected) {
        if (!Arrays.equals((char[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public CharArrayAssert isNotEqualTo(char[] array) {
        if (Arrays.equals((char[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public CharArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((char[])this.actual).length;
    }

    public CharArrayAssert isSameAs(char[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public CharArrayAssert isNotSameAs(char[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

