/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanArrayAssert
extends ArrayAssert<boolean[]> {
    BooleanArrayAssert(boolean ... actual) {
        super(actual);
    }

    public BooleanArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public BooleanArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public BooleanArrayAssert contains(boolean ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public BooleanArrayAssert containsOnly(boolean ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public BooleanArrayAssert excludes(boolean ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((boolean[])this.actual);
    }

    private List<Object> list(boolean[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (boolean value : values) {
            list.add(value);
        }
        return list;
    }

    public BooleanArrayAssert satisfies(Condition<boolean[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public BooleanArrayAssert doesNotSatisfy(Condition<boolean[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public BooleanArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public BooleanArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public BooleanArrayAssert isEqualTo(boolean[] expected) {
        if (!Arrays.equals((boolean[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public BooleanArrayAssert isNotEqualTo(boolean[] array) {
        if (Arrays.equals((boolean[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public BooleanArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((boolean[])this.actual).length;
    }

    public BooleanArrayAssert isSameAs(boolean[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public BooleanArrayAssert isNotSameAs(boolean[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

