/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.List;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ArrayAssert<T>
extends GroupAssert<T> {
    ArrayAssert(T actual) {
        super(actual);
    }

    final void assertContains(List<Object> values) {
        List<Object> copyOfActual = this.copyActual();
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object value : values) {
            if (copyOfActual.contains(value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            this.failIfElementsNotFound(notFound);
        }
    }

    final void assertContainsOnly(List<Object> values) {
        List<Object> copyOfActual = this.copyActual();
        ArrayList<Object> notFound = new ArrayList<Object>();
        for (Object value : values) {
            if (!copyOfActual.contains(value)) {
                notFound.add(value);
                continue;
            }
            copyOfActual.remove(value);
        }
        if (!notFound.isEmpty()) {
            this.failIfElementsNotFound(notFound);
        }
        if (!copyOfActual.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"unexpected element(s):", Formatting.inBrackets(copyOfActual.toArray()), " in array:", this.actualInBrackets()}));
        }
    }

    private void failIfElementsNotFound(List<Object> notFound) {
        this.fail(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " does not contain element(s):", Formatting.inBrackets(notFound.toArray())}));
    }

    final void assertExcludes(List<Object> values) {
        List<Object> copyOfActual = this.copyActual();
        ArrayList<Object> found = new ArrayList<Object>();
        for (Object value : values) {
            if (!copyOfActual.contains(value)) continue;
            found.add(value);
        }
        if (!found.isEmpty()) {
            this.fail(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " does not exclude element(s):", Formatting.inBrackets(found.toArray())}));
        }
    }

    abstract List<Object> copyActual();

    final String actualInBrackets() {
        return Formatting.inBrackets(this.actual);
    }

    final void assertArrayNotNull() {
        if (this.actual == null) {
            this.fail("expecting a non-null array, but it was null");
        }
    }

    @Override
    public final void isEmpty() {
        if (this.actualGroupSize() > 0) {
            this.fail(Strings.concat((Object[])new Object[]{"expecting empty array, but was:", this.actualInBrackets()}));
        }
    }

    @Override
    public final void isNullOrEmpty() {
        if (this.actual == null || this.actualGroupSize() == 0) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty array, but was:", this.actualInBrackets()}));
    }

    final void assertNotEmpty() {
        if (this.actualGroupSize() == 0) {
            this.fail("expecting a non-empty array, but it was empty");
        }
    }

    final void assertHasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize == expected) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for array:", this.actualInBrackets()}));
    }
}

