/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.awt.Toolkit;
import org.fest.assertions.Assertions;
import org.fest.swing.util.Modifiers;
import org.fest.util.Strings;

public final class Platform {
    private static boolean isWindows;
    private static boolean isWindows9x;
    private static boolean isWindowsXP;
    private static boolean isMacintosh;
    private static boolean isOSX;
    private static boolean isX11;
    private static boolean isSolaris;
    private static boolean isHPUX;
    private static boolean isLinux;

    static void initialize(String osName) {
        isWindows = osName.startsWith("Windows");
        isWindows9x = isWindows && Platform.containsAny(osName, "95", "98", "ME");
        isWindowsXP = isWindows && osName.contains("XP");
        isMacintosh = Platform.property("mrj.version") != null;
        isOSX = isMacintosh && osName.contains("OS X");
        isX11 = !isOSX && !isWindows;
        isSolaris = osName.startsWith("SunOS") || osName.startsWith("Solaris");
        isHPUX = osName.equals("HP-UX");
        isLinux = osName.equals("Linux");
    }

    private static boolean containsAny(String s, String ... subs) {
        for (String sub : subs) {
            if (!s.contains(sub)) continue;
            return true;
        }
        return false;
    }

    private static String property(String name) {
        return System.getProperty(name);
    }

    public static int controlOrCommandKey() {
        int menuShortcutKeyMask = Platform.controlOrCommandMask();
        int[] keys = Modifiers.keysFor(menuShortcutKeyMask);
        Assertions.assertThat((int[])keys).as(Strings.concat((Object[])new Object[]{"Key code for mask ", String.valueOf(menuShortcutKeyMask)})).isNotNull().hasSize(1);
        return keys[0];
    }

    public static int controlOrCommandMask() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public static boolean canResizeWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean canMoveWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isWindows9x() {
        return isWindows9x;
    }

    public static boolean isWindowsXP() {
        return isWindowsXP;
    }

    public static boolean isMacintosh() {
        return isMacintosh;
    }

    public static boolean isOSX() {
        return isOSX;
    }

    public static boolean isX11() {
        return isX11;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isHPUX() {
        return isHPUX;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    private Platform() {
    }

    static {
        Platform.initialize(Platform.property("os.name"));
    }
}

