/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventQueueMapping {
    final Map<Component, WeakReference<EventQueue>> queueMap = new WeakHashMap<Component, WeakReference<EventQueue>>();

    EventQueueMapping() {
    }

    void addQueueFor(Component c) {
        EventQueue queue = c.getToolkit().getSystemEventQueue();
        this.queueMap.put(c, new WeakReference<EventQueue>(queue));
    }

    EventQueue queueFor(Component c) {
        EventQueue queue = this.storedQueueFor(c);
        if (queue == null) {
            return c.getToolkit().getSystemEventQueue();
        }
        return queue;
    }

    EventQueue storedQueueFor(Component c) {
        return this.queueFrom(this.queueMap.get(c));
    }

    Collection<EventQueue> eventQueues() {
        HashSet<EventQueue> eventQueues = new HashSet<EventQueue>();
        for (WeakReference<EventQueue> reference : this.queueMap.values()) {
            EventQueue queue = this.queueFrom(reference);
            if (queue == null) continue;
            eventQueues.add(queue);
        }
        return eventQueues;
    }

    private EventQueue queueFrom(WeakReference<EventQueue> reference) {
        if (reference == null) {
            return null;
        }
        return (EventQueue)reference.get();
    }
}

