/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import org.fest.swing.input.DisposedWindowMonitor;
import org.fest.swing.listener.WeakEventListener;

class EventNormalizer
implements AWTEventListener {
    private final DisposedWindowMonitor disposedWindowMonitor;
    private WeakEventListener weakEventListener;
    private AWTEventListener listener;

    EventNormalizer() {
        this(new DisposedWindowMonitor());
    }

    EventNormalizer(DisposedWindowMonitor disposedWindowMonitor) {
        this.disposedWindowMonitor = disposedWindowMonitor;
    }

    void startListening(Toolkit toolkit, AWTEventListener delegate, long mask) {
        this.listener = delegate;
        this.weakEventListener = WeakEventListener.attachAsWeakEventListener(toolkit, this, mask);
    }

    void stopListening() {
        this.disposeWeakEventListener();
        this.listener = null;
    }

    private void disposeWeakEventListener() {
        if (this.weakEventListener == null) {
            return;
        }
        this.weakEventListener.dispose();
        this.weakEventListener = null;
    }

    public void eventDispatched(AWTEvent event) {
        boolean discard = this.disposedWindowMonitor.isDuplicateDispose(event);
        if (!discard && this.listener != null) {
            this.delegate(event);
        }
    }

    void delegate(AWTEvent e) {
        this.listener.eventDispatched(e);
    }
}

