/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

class ParentFinder {
    ParentFinder() {
    }

    Container parentOf(Component c) {
        Container p = c.getParent();
        if (p == null && c instanceof JInternalFrame) {
            p = this.parentOf((JInternalFrame)c);
        }
        return p;
    }

    private Container parentOf(JInternalFrame internalFrame) {
        JInternalFrame.JDesktopIcon icon = internalFrame.getDesktopIcon();
        if (icon != null) {
            return icon.getDesktopPane();
        }
        return null;
    }

    Component invokerFor(Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        return this.invokerFor(parent);
    }

    Window windowFor(Component c) {
        Component invoker;
        if (c == null) {
            return null;
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        if (c instanceof MenuElement && (invoker = this.invokerFor(c)) != null) {
            return this.windowFor(invoker);
        }
        return this.windowFor(this.parentOf(c));
    }
}

