/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.AbstractButtonDriver;
import org.fest.swing.fixture.TwoStateButtonFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRadioButtonFixture
extends TwoStateButtonFixture<JRadioButton> {
    private AbstractButtonDriver driver;

    public JRadioButtonFixture(Robot robot, JRadioButton target) {
        super(robot, target);
        this.createDriver();
    }

    public JRadioButtonFixture(Robot robot, String buttonName) {
        super(robot, buttonName, JRadioButton.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new AbstractButtonDriver(this.robot));
    }

    void updateDriver(AbstractButtonDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public JRadioButtonFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JRadioButtonFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JRadioButtonFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JRadioButtonFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JRadioButtonFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JRadioButtonFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JRadioButtonFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    public JRadioButtonFixture requireNotSelected() {
        this.driver.requireNotSelected((AbstractButton)this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    public JRadioButtonFixture requireSelected() {
        this.driver.requireSelected((AbstractButton)this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JRadioButtonFixture requireText(String expected) {
        this.driver.requireText((AbstractButton)this.target, expected);
        return this;
    }

    @Override
    public String text() {
        return ((JRadioButton)this.target).getText();
    }
}

