/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.FrameDriver;
import org.fest.swing.fixture.FrameLikeFixture;
import org.fest.swing.fixture.WindowFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameFixture
extends WindowFixture<Frame>
implements FrameLikeFixture {
    private FrameDriver driver;

    public FrameFixture(Frame target) {
        super(target);
        this.createDriver();
    }

    public FrameFixture(Robot robot, Frame target) {
        super(robot, target);
        this.createDriver();
    }

    public FrameFixture(Robot robot, String name) {
        super(robot, name, Frame.class);
        this.createDriver();
    }

    public FrameFixture(String name) {
        super(name, Frame.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new FrameDriver(this.robot));
    }

    void updateDriver(FrameDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public FrameFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public FrameFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public FrameFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public FrameFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public FrameFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public FrameFixture iconify() {
        this.driver.iconify((Frame)this.target);
        return this;
    }

    @Override
    public FrameFixture deiconify() {
        this.driver.deiconify((Frame)this.target);
        return this;
    }

    @Override
    public FrameFixture maximize() {
        this.driver.maximize((Frame)this.target);
        return this;
    }

    @Override
    public FrameFixture normalize() {
        this.driver.normalize((Frame)this.target);
        return this;
    }

    @Override
    public FrameFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public FrameFixture moveTo(Point p) {
        this.driver.moveTo((Window)this.target, p);
        return this;
    }

    @Override
    public FrameFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public FrameFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public FrameFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public FrameFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public FrameFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public FrameFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public FrameFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public FrameFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public FrameFixture requireSize(Dimension size) {
        this.driver.requireSize(this.target, size);
        return this;
    }

    @Override
    public FrameFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public FrameFixture resizeHeightTo(int height) {
        this.driver.resizeHeightTo((Window)this.target, height);
        return this;
    }

    @Override
    public FrameFixture resizeTo(Dimension size) {
        this.driver.resizeTo((Window)this.target, size);
        return this;
    }

    @Override
    public FrameFixture resizeWidthTo(int width) {
        this.driver.resizeWidthTo((Window)this.target, width);
        return this;
    }

    public FrameFixture show() {
        this.driver.show((Window)this.target);
        return this;
    }

    public FrameFixture show(Dimension size) {
        this.driver.show((Window)this.target, size);
        return this;
    }

    @Override
    public void close() {
        this.driver.close((Window)this.target);
    }
}

