/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

final class KeyStrokes {
    static KeyStroke[] findKeyStrokesForAction(String actionName, Object actionKey, InputMap inputMap) {
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            if (!actionKey.equals(inputMap.get(keyStroke))) continue;
            keyStrokes.add(keyStroke);
        }
        int size = keyStrokes.size();
        if (size > 0) {
            return keyStrokes.toArray(new KeyStroke[size]);
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to find valid input event for action with key ", Strings.quote((String)actionName)}));
    }

    private KeyStrokes() {
    }
}

