/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.table.JTableHeader;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Strings;

public class JTableHeaderLocation {
    public Point pointAt(JTableHeader tableHeader, String columnName) {
        int validatedIndex = this.validatedIndex(tableHeader, this.indexOf(tableHeader, columnName));
        Rectangle r = tableHeader.getHeaderRect(validatedIndex);
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public Point pointAt(JTableHeader tableHeader, int index) {
        int validatedIndex = this.validatedIndex(tableHeader, index);
        Rectangle r = tableHeader.getHeaderRect(validatedIndex);
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    private int validatedIndex(JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        if (index >= 0 && index < itemCount) {
            return index;
        }
        throw new LocationUnavailableException(org.fest.util.Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ") should be between [", String.valueOf(0), "] and [", String.valueOf(itemCount - 1), "] (inclusive)"}));
    }

    public int indexOf(JTableHeader tableHeader, String columnName) {
        int size = this.columnCount(tableHeader);
        for (int i = 0; i < size; ++i) {
            if (!Strings.match(columnName, this.columnName(tableHeader, i))) continue;
            return i;
        }
        return -1;
    }

    private int columnCount(JTableHeader header) {
        return header.getColumnModel().getColumnCount();
    }

    private String columnName(JTableHeader tableHeader, int index) {
        return tableHeader.getTable().getModel().getColumnName(index);
    }
}

