/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJTableCellReader;
import org.fest.swing.driver.BasicJTableCellWriter;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableCell;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.util.Arrays;
import org.fest.util.Strings;

public class JTableDriver
extends JComponentDriver {
    private static final String CONTENTS_PROPERTY = "contents";
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private static final String VALUE_PROPERTY = "value";
    private final JTableLocation location = new JTableLocation();
    private JTableCellReader cellReader;
    private JTableCellWriter cellWriter;

    public JTableDriver(Robot robot) {
        super(robot);
        this.cellReader(new BasicJTableCellReader());
        this.cellWriter(new BasicJTableCellWriter(robot));
    }

    public String selectionValue(JTable table) {
        if (table.getSelectedRowCount() == 0) {
            return null;
        }
        return this.value(table, table.getSelectedRow(), table.getSelectedColumn());
    }

    public String value(JTable table, JTableCell cell) {
        this.validate(table, cell);
        return this.value(table, cell.row, cell.column);
    }

    public String value(JTable table, int row, int column) {
        JTableCell.validateRow(table, row);
        JTableCell.validateColumn(table, column);
        return this.cellReader.valueAt(table, row, column);
    }

    public Font font(JTable table, JTableCell cell) {
        this.validate(table, cell);
        return this.cellReader.fontAt(table, cell.row, cell.column);
    }

    public Color background(JTable table, JTableCell cell) {
        this.validate(table, cell);
        return this.cellReader.backgroundAt(table, cell.row, cell.column);
    }

    public Color foreground(JTable table, JTableCell cell) {
        this.validate(table, cell);
        return this.cellReader.foregroundAt(table, cell.row, cell.column);
    }

    public void selectCells(final JTable table, final JTableCell[] cells) {
        if (cells == null) {
            throw new NullPointerException("Array of table cells to select should not be null");
        }
        if (org.fest.util.Arrays.isEmpty((Object[])cells)) {
            throw new IllegalArgumentException("Array of table cells to select should not be empty");
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return cells.length;
            }

            void selectElement(int index) {
                JTableDriver.this.selectCell(table, cells[index]);
            }
        }.multiSelect();
    }

    public void requireNoSelection(JTable table) {
        if (table.getSelectedColumnCount() == 0 && table.getSelectedRowCount() == 0) {
            return;
        }
        String message = Strings.concat((Object[])new Object[]{"[", JTableDriver.propertyName(table, SELECTION_PROPERTY), "] expected no selection but was:<rows", org.fest.util.Arrays.format((Object)table.getSelectedRows()), ", columns", org.fest.util.Arrays.format((Object)table.getSelectedColumns()), ">"});
        Fail.fail((String)message);
    }

    public void selectCell(JTable table, JTableCell cell) {
        if (!table.isEnabled()) {
            return;
        }
        this.validate(table, cell);
        if (this.isCellSelected(table, cell)) {
            return;
        }
        this.click(table, cell, MouseButton.LEFT_BUTTON, 1);
    }

    private boolean isCellSelected(JTable table, JTableCell cell) {
        return table.isRowSelected(cell.row) && table.isColumnSelected(cell.column) && table.getSelectedRowCount() == 1;
    }

    public void click(JTable table, JTableCell cell, MouseButton mouseButton, int times) {
        this.validate(table, cell);
        this.scrollToVisible(table, this.location.cellBounds(table, cell));
        this.robot.click(table, this.pointAt(table, cell), mouseButton, times);
    }

    public void drag(JTable table, JTableCell cell) {
        this.validate(table, cell);
        this.scrollToVisible(table, this.location.cellBounds(table, cell));
        this.drag((Component)table, this.pointAt(table, cell));
    }

    public void drop(JTable table, JTableCell cell) {
        this.validate(table, cell);
        this.scrollToVisible(table, this.location.cellBounds(table, cell));
        this.drop((Component)table, this.pointAt(table, cell));
    }

    public JPopupMenu showPopupMenuAt(JTable table, JTableCell cell) {
        this.scrollToVisible(table, this.location.cellBounds(table, cell));
        return this.robot.showPopupMenu(table, this.pointAt(table, cell));
    }

    public Point pointAt(JTable table, JTableCell cell) {
        this.validate(table, cell);
        return this.location.pointAt(table, cell.row, cell.column);
    }

    public void requireContents(JTable table, String[][] contents) {
        String[][] actual = this.contents(table);
        Arrays.assertEquals(actual, contents, JTableDriver.propertyName(table, CONTENTS_PROPERTY));
    }

    public String[][] contents(JTable table) {
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        String[][] contents = new String[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                contents[row][col] = this.cellReader.valueAt(table, row, col);
            }
        }
        return contents;
    }

    public void requireCellValue(JTable table, JTableCell cell, String value) {
        this.validate(table, cell);
        Assertions.assertThat((String)this.value(table, cell)).as(JTableDriver.cellProperty(table, cell, VALUE_PROPERTY)).isEqualTo(value);
    }

    public static String cellProperty(JTable table, JTableCell cell, String propertyName) {
        return Strings.concat((Object[])new Object[]{JTableDriver.propertyName(table, propertyName), " - ", cell});
    }

    public void enterValueInCell(JTable table, JTableCell cell, String value) {
        this.requireEditable(table, cell);
        this.requireEnabled(table);
        this.cellWriter.enterValue(table, cell.row, cell.column, value);
    }

    public void requireEditable(JTable table, JTableCell cell) {
        this.requireEditableEqualTo(table, cell, true);
    }

    public void requireNotEditable(JTable table, JTableCell cell) {
        this.requireEditableEqualTo(table, cell, false);
    }

    private void requireEditableEqualTo(JTable table, JTableCell cell, boolean editable) {
        this.validate(table, cell);
        boolean cellEditable = table.isCellEditable(cell.row, cell.column);
        Assertions.assertThat((boolean)cellEditable).as(JTableDriver.cellProperty(table, cell, EDITABLE_PROPERTY)).isEqualTo(editable);
    }

    public Component cellEditor(JTable table, JTableCell cell) {
        this.validate(table, cell);
        return this.cellWriter.editorForCell(table, cell.row, cell.column);
    }

    public void startCellEditing(JTable table, JTableCell cell) {
        this.validate(table, cell);
        this.cellWriter.startCellEditing(table, cell.row, cell.column);
    }

    public void stopCellEditing(JTable table, JTableCell cell) {
        this.validate(table, cell);
        this.cellWriter.stopCellEditing(table, cell.row, cell.column);
    }

    public void cancelCellEditing(JTable table, JTableCell cell) {
        this.validate(table, cell);
        this.cellWriter.cancelCellEditing(table, cell.row, cell.column);
    }

    public void validate(JTable table, JTableCell cell) {
        if (cell == null) {
            throw new NullPointerException("Table cell cannot be null");
        }
        cell.validateBoundsIn(table);
    }

    public void cellReader(JTableCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }

    public void cellWriter(JTableCellWriter newCellWriter) {
        CommonValidations.validateCellWriter(newCellWriter);
        this.cellWriter = newCellWriter;
    }
}

