/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JSplitPane;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;

public class JSplitPaneDriver
extends JComponentDriver {
    public JSplitPaneDriver(Robot robot) {
        super(robot);
    }

    public void moveDividerTo(JSplitPane splitPane, int location) {
        if (!splitPane.isEnabled()) {
            return;
        }
        this.simulateMovingDivider(splitPane, location);
        this.robot.invokeAndWait(splitPane, new SetDividerLocationTask(splitPane, location));
    }

    private void simulateMovingDivider(JSplitPane split, int location) {
        if (split.getOrientation() == 0) {
            this.simulateMovingDividerVertically(split, location);
            return;
        }
        this.simulateMovingDividerHorizontally(split, location);
    }

    private void simulateMovingDividerVertically(JSplitPane splitPane, int location) {
        this.robot.moveMouse(splitPane, splitPane.getWidth() / 2, splitPane.getDividerLocation());
        this.robot.pressMouse(MouseButton.LEFT_BUTTON);
        this.robot.moveMouse(splitPane, splitPane.getWidth() / 2, location);
        this.robot.releaseLeftMouseButton();
    }

    private void simulateMovingDividerHorizontally(JSplitPane splitPane, int location) {
        this.robot.moveMouse(splitPane, splitPane.getDividerLocation(), splitPane.getHeight() / 2);
        this.robot.pressMouse(MouseButton.LEFT_BUTTON);
        this.robot.moveMouse(splitPane, location, splitPane.getHeight() / 2);
        this.robot.releaseLeftMouseButton();
    }

    private static class SetDividerLocationTask
    implements Runnable {
        private final JSplitPane target;
        private final int location;

        SetDividerLocationTask(JSplitPane target, int location) {
            this.target = target;
            this.location = location;
        }

        public void run() {
            this.target.setDividerLocation(this.location);
        }
    }
}

