/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPopupMenuDriver
extends JComponentDriver {
    public JPopupMenuDriver(Robot robot) {
        super(robot);
    }

    public String[] menuLabelsOf(JPopupMenu popupMenu) {
        MenuElement[] subElements = popupMenu.getSubElements();
        String[] result = new String[subElements.length];
        for (int i = 0; i < subElements.length; ++i) {
            result[i] = JPopupMenuDriver.asString(subElements[i]);
        }
        return result;
    }

    static String asString(MenuElement e) {
        Component c = e.getComponent();
        if (c instanceof JMenuItem) {
            return ((JMenuItem)c).getText();
        }
        return "-";
    }

    public JMenuItem menuItem(JPopupMenu popupMenu, String name) {
        return this.robot.finder().findByName((Container)popupMenu, name, JMenuItem.class);
    }

    public JMenuItem menuItem(JPopupMenu popupMenu, GenericTypeMatcher<? extends JMenuItem> matcher) {
        return this.robot.finder().find((Container)popupMenu, matcher);
    }
}

