/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import org.fest.util.Strings;

public class JListLocation {
    public Point pointAt(JList list, int index) {
        this.validate(list, index);
        Rectangle rect = list.getCellBounds(index, index);
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    public void validate(JList list, int index) {
        int itemCount = this.sizeOf(list);
        if (index >= 0 && index < itemCount) {
            return;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ") should be between [", String.valueOf(0), "] and [", String.valueOf(itemCount - 1), "] (inclusive)"}));
    }

    private int sizeOf(JList list) {
        return list.getModel().getSize();
    }
}

