/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JInternalFrameAction;
import org.fest.swing.driver.JInternalFrameSetPropertyTask;
import org.fest.swing.driver.WindowLikeContainerDriver;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class JInternalFrameDriver
extends WindowLikeContainerDriver {
    public JInternalFrameDriver(Robot robot) {
        super(robot);
    }

    public void moveToFront(JInternalFrame frame) {
        this.robot.invokeAndWait(new MoveToFrontTask(frame));
    }

    public void moveToBack(JInternalFrame frame) {
        this.robot.invokeAndWait(new MoveToBackTask(frame));
    }

    public void maximize(JInternalFrame frame) {
        if (!frame.isMaximizable()) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The JInternalFrame <", Formatting.format(frame), "> is not maximizable"}));
        }
        this.maximizeOrNormalize(frame, JInternalFrameAction.MAXIMIZE);
    }

    public void normalize(JInternalFrame frame) {
        this.maximizeOrNormalize(frame, JInternalFrameAction.NORMALIZE);
    }

    private void maximizeOrNormalize(JInternalFrame frame, JInternalFrameAction action) {
        JComponent clickTarget = frame;
        if (frame.isIcon()) {
            clickTarget = frame.getDesktopIcon();
        }
        Point p = this.maximizeLocation(clickTarget);
        this.robot.moveMouse(clickTarget, p.x, p.y);
        if (frame.isIcon()) {
            this.deiconify(frame);
        }
        this.setProperty(new SetMaximumTask(frame, action));
    }

    public void iconify(JInternalFrame frame) {
        if (frame.isIcon()) {
            return;
        }
        if (!frame.isIconifiable()) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The JInternalFrame <", Formatting.format(frame), "> is not iconifiable"}));
        }
        Point p = this.iconifyLocation(frame);
        this.robot.moveMouse(frame, p.x, p.y);
        this.setProperty(new SetIconTask(frame, JInternalFrameAction.ICONIFY));
    }

    public void deiconify(JInternalFrame frame) {
        if (!frame.isIcon()) {
            return;
        }
        JInternalFrame.JDesktopIcon c = frame.getDesktopIcon();
        Point p = this.iconifyLocation(c);
        this.robot.moveMouse(c, p.x, p.y);
        this.setProperty(new SetIconTask(frame, JInternalFrameAction.DEICONIFY));
    }

    void setProperty(JInternalFrameSetPropertyTask task) {
        PropertyVetoException vetoError;
        this.robot.invokeAndWait(task);
        JInternalFrameSetPropertyTask.PropertyVeto veto = task.veto();
        PropertyVetoException propertyVetoException = vetoError = veto != null ? veto.cause() : null;
        if (vetoError == null) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{task.action.name, " of ", Formatting.format(task.target), " was vetoed: <", vetoError.getMessage(), ">"}));
    }

    public void resizeWidthTo(JInternalFrame w, int width) {
        this.resizeTo(w, new Dimension(width, w.getHeight()));
    }

    public void resizeHeightTo(JInternalFrame w, int height) {
        this.resizeTo(w, new Dimension(w.getWidth(), height));
    }

    public void resizeTo(JInternalFrame w, Dimension size) {
        this.resize(w, size.width, size.height);
    }

    public void moveTo(JInternalFrame w, Point where) {
        this.move(w, where.x, where.y);
    }

    public void close(JInternalFrame frame) {
        if (!frame.isClosable()) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The JInternalFrame <", Formatting.format(frame), "> is not closable"}));
        }
        Point p = this.closeLocation(frame);
        this.robot.moveMouse(frame, p.x, p.y);
        this.robot.invokeAndWait(new CloseFrameTask(frame));
    }

    private static class CloseFrameTask
    implements Runnable {
        private final JInternalFrame target;

        CloseFrameTask(JInternalFrame target) {
            this.target = target;
        }

        public void run() {
            this.target.doDefaultCloseAction();
        }
    }

    private static class SetIconTask
    extends JInternalFrameSetPropertyTask {
        SetIconTask(JInternalFrame target, JInternalFrameAction action) {
            super(target, action);
        }

        public void execute() throws PropertyVetoException {
            this.target.setIcon(this.action.value);
        }
    }

    private static class SetMaximumTask
    extends JInternalFrameSetPropertyTask {
        SetMaximumTask(JInternalFrame target, JInternalFrameAction action) {
            super(target, action);
        }

        public void execute() throws PropertyVetoException {
            this.target.setMaximum(this.action.value);
        }
    }

    private static class MoveToBackTask
    implements Runnable {
        private final JInternalFrame f;

        MoveToBackTask(JInternalFrame f) {
            this.f = f;
        }

        public void run() {
            this.f.toBack();
        }
    }

    private static class MoveToFrontTask
    implements Runnable {
        private final JInternalFrame f;

        MoveToFrontTask(JInternalFrame f) {
            this.f = f;
        }

        public void run() {
            this.f.toFront();
        }
    }
}

