/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableLocation;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public abstract class AbstractJTableCellWriter
implements JTableCellWriter {
    protected final Robot robot;
    private final JComponentDriver driver;
    private final JTableLocation tableLocation = new JTableLocation();

    public AbstractJTableCellWriter(Robot robot) {
        this.robot = robot;
        this.driver = new JComponentDriver(robot);
    }

    protected final void clickCell(JTable table, int row, int column) {
        this.clickCell(table, row, column, 1);
    }

    protected final void clickCell(JTable table, int row, int column, int times) {
        this.driver.scrollToVisible(table, this.tableLocation.cellBounds(table, row, column));
        this.robot.click(table, this.tableLocation.pointAt(table, row, column), MouseButton.LEFT_BUTTON, times);
    }

    protected final ActionFailedException cannotHandleEditor(Component editor) {
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to handle editor component of type ", this.editorTypeName(editor)}));
    }

    private String editorTypeName(Component editor) {
        if (editor == null) {
            return "<null>";
        }
        return editor.getClass().getName();
    }

    public Component editorForCell(JTable table, int row, int column) {
        TableCellEditor cellEditor = table.getCellEditor(row, column);
        if (cellEditor == null) {
            return null;
        }
        return cellEditor.getTableCellEditorComponent(table, table.getValueAt(row, column), false, row, column);
    }
}

