/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Robot;
import org.fest.swing.core.ComponentLookupScope;
import org.fest.swing.core.EventMode;
import org.fest.swing.util.Platform;

public final class Settings {
    private static final int DEFAULT_DELAY = 30000;
    private EventMode eventMode;
    private ComponentLookupScope componentLookupScope;
    private int timeoutToBeVisible;
    private int timeoutToFindPopup;
    private int delayBetweenEvents;
    private int dragDelay;
    private int dropDelay;
    private int eventPostingDelay;
    private int idleTimeout;
    private Robot robot;

    public Settings() {
        this.timeoutToBeVisible(30000);
        this.timeoutToFindPopup(30000);
        this.delayBetweenEvents(60);
        this.dragDelay(0);
        this.dropDelay(0);
        this.eventPostingDelay(100);
        this.componentLookupScope(ComponentLookupScope.DEFAULT);
        this.idleTimeout(10000);
    }

    void attachTo(Robot newRobot) {
        this.robot = newRobot;
        if (this.delayBetweenEvents < 0) {
            this.delayBetweenEvents = this.robot.getAutoDelay();
        } else {
            this.updateRobotAutoDelay();
        }
        this.eventMode(EventMode.ROBOT);
    }

    Robot robot() {
        return this.robot;
    }

    public EventMode eventMode() {
        return this.eventMode;
    }

    public void eventMode(EventMode newEventMode) {
        this.eventMode = newEventMode;
    }

    public int delayBetweenEvents() {
        return this.delayBetweenEvents;
    }

    public void delayBetweenEvents(int ms) {
        this.delayBetweenEvents = this.valueToUpdate(ms, -1, 60000);
        if (this.robot != null) {
            this.updateRobotAutoDelay();
        }
    }

    private void updateRobotAutoDelay() {
        this.robot.setAutoDelay(this.delayBetweenEvents);
    }

    public int timeoutToBeVisible() {
        return this.timeoutToBeVisible;
    }

    public void timeoutToBeVisible(int ms) {
        this.timeoutToBeVisible = this.valueToUpdate(ms, 0, 60000);
    }

    public int timeoutToFindPopup() {
        return this.timeoutToFindPopup;
    }

    public void timeoutToFindPopup(int ms) {
        this.timeoutToFindPopup = this.valueToUpdate(ms, 0, 60000);
    }

    public int dragDelay() {
        return this.dragDelay;
    }

    public void dragDelay(int ms) {
        int min = Platform.isX11() || Platform.isOSX() ? 100 : 0;
        this.dragDelay = this.valueToUpdate(ms, min, 60000);
    }

    public int eventPostingDelay() {
        return this.eventPostingDelay;
    }

    public void eventPostingDelay(int ms) {
        this.eventPostingDelay = this.valueToUpdate(ms, 0, 1000);
    }

    public int dropDelay() {
        return this.dropDelay;
    }

    public void dropDelay(int ms) {
        int min = Platform.isWindows() ? 200 : 0;
        this.dropDelay = this.valueToUpdate(ms, min, 60000);
    }

    public ComponentLookupScope componentLookupScope() {
        return this.componentLookupScope;
    }

    public void componentLookupScope(ComponentLookupScope scope) {
        this.componentLookupScope = scope;
    }

    public int idleTimeout() {
        return this.idleTimeout;
    }

    public void idleTimeout(int ms) {
        this.idleTimeout = this.valueToUpdate(ms, 0, Integer.MAX_VALUE);
    }

    private int valueToUpdate(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

