/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.fest.assertions.Fail;
import org.fest.swing.core.AWTEventPoster;
import org.fest.swing.core.ActivateWindowTask;
import org.fest.swing.core.BasicComponentFinder;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.EventMode;
import org.fest.swing.core.FocusMonitor;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.InputEventGenerators;
import org.fest.swing.core.InputModifiers;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Pause;
import org.fest.swing.core.RequestFocusTask;
import org.fest.swing.core.Robot;
import org.fest.swing.core.ScreenLock;
import org.fest.swing.core.Settings;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.core.WindowAncestorFinder;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.input.InputState;
import org.fest.swing.keystroke.KeyStrokeMap;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.util.AWT;
import org.fest.swing.util.Modifiers;
import org.fest.swing.util.Platform;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotFixture
implements Robot {
    private static final int POPUP_DELAY = 10000;
    private static final int POPUP_TIMEOUT = 5000;
    private static final int WINDOW_DELAY = 20000;
    private static final ComponentMatcher POPUP_MATCHER = new TypeMatcher(JPopupMenu.class, true);
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        public void run() {
        }
    };
    private static final int BUTTON_MASK = 28;
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private static InputState inputState = new InputState(toolkit);
    private final ComponentHierarchy hierarchy;
    private final ComponentFinder finder;
    private final Settings settings;
    private final AWTEventPoster eventPoster;
    private final InputEventGenerators eventGenerators;

    public static RobotFixture robotWithNewAwtHierarchy() {
        return new RobotFixture(NewHierarchy.ignoreExistingComponents());
    }

    public static RobotFixture robotWithCurrentAwtHierarchy() {
        return new RobotFixture(new ExistingHierarchy());
    }

    RobotFixture(ComponentHierarchy hierarchy) {
        ScreenLock.instance().acquire(this);
        this.hierarchy = hierarchy;
        this.settings = new Settings();
        this.eventPoster = new AWTEventPoster(toolkit, inputState, windowMonitor, this.settings);
        this.eventGenerators = new InputEventGenerators(this.eventPoster);
        this.finder = new BasicComponentFinder(this.hierarchy);
    }

    @Override
    public ComponentPrinter printer() {
        return this.finder().printer();
    }

    @Override
    public ComponentFinder finder() {
        return this.finder;
    }

    @Override
    public void showWindow(Window w) {
        this.showWindow(w, null, true);
    }

    @Override
    public void showWindow(Window w, Dimension size) {
        this.showWindow(w, size, true);
    }

    @Override
    public void showWindow(final Window w, final Dimension size, final boolean pack) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (pack) {
                    RobotFixture.this.packAndEnsureSafePosition(w);
                }
                if (size != null) {
                    w.setSize(size);
                }
                w.setVisible(true);
            }
        });
        this.waitForWindow(w);
    }

    void packAndEnsureSafePosition(Window w) {
        w.pack();
        w.setLocation(100, 100);
    }

    private void waitForWindow(Window w) {
        long start = System.currentTimeMillis();
        while (this.isRobotMode() && !windowMonitor.isWindowReady(w) || !w.isShowing()) {
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 20000L) {
                throw new WaitTimedOutError(Strings.concat((Object[])new Object[]{"Timed out waiting for Window to open (", String.valueOf(elapsed), "ms)"}));
            }
            Pause.pause();
        }
    }

    @Override
    public void close(Window w) {
        if (!w.isShowing()) {
            return;
        }
        this.focus(w);
        try {
            Point p = this.closeLocation(w);
            this.moveMouse(w, p.x, p.y);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        WindowEvent event = new WindowEvent(w, 201);
        Applet applet = this.findAppletDescendent(w);
        EventQueue eq = windowMonitor.eventQueueFor(applet != null ? applet : w);
        eq.postEvent(event);
    }

    private Applet findAppletDescendent(Container c) {
        try {
            return this.finder.findByType(c, Applet.class);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    private Point closeLocation(Container c) {
        if (Platform.isOSX()) {
            return this.closeLocationForOSX(c);
        }
        Insets insets = c.getInsets();
        return new Point(c.getSize().width - insets.right - 10, insets.top / 2);
    }

    private Point closeLocationForOSX(Container c) {
        Insets insets = c.getInsets();
        return new Point(insets.left + 15, insets.top / 2);
    }

    @Override
    public void focus(Component c) {
        this.focus(c, false);
    }

    @Override
    public void focusAndWaitForFocusGain(Component c) {
        this.focus(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void focus(Component c, boolean wait) {
        Component currentOwner = FocusOwnerFinder.focusOwner();
        if (currentOwner == c) {
            return;
        }
        FocusMonitor focusMonitor = FocusMonitor.addFocusMonitorTo(c);
        this.moveMouse(c);
        this.waitForIdle();
        Window currentOwnerAncestor = currentOwner != null ? WindowAncestorFinder.ancestorOf(currentOwner) : null;
        Window componentAncestor = WindowAncestorFinder.ancestorOf(c);
        if (currentOwnerAncestor != componentAncestor) {
            this.activate(componentAncestor);
            this.waitForIdle();
        }
        this.invokeAndWait(c, new RequestFocusTask(c));
        try {
            if (wait) {
                TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().timeoutToBeVisible());
                while (!focusMonitor.hasFocus()) {
                    if (watch.isTimeOut()) {
                        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Focus change to ", Formatting.format(c), " failed"}));
                    }
                    Pause.pause();
                }
            }
        }
        finally {
            c.removeFocusListener(focusMonitor);
        }
    }

    private void activate(Window w) {
        this.invokeAndWait(w, new ActivateWindowTask(w));
        this.moveMouse(w);
    }

    @Override
    public void invokeAndWait(Runnable action) {
        this.invokeAndWait(null, action);
    }

    @Override
    public void invokeAndWait(Component c, Runnable action) {
        this.invokeLater(c, action);
        this.waitForIdle();
    }

    @Override
    public void invokeLater(Component c, Runnable action) {
        EventQueue queue = this.eventQueueFor(c);
        queue.postEvent(new InvocationEvent((Object)toolkit, action));
    }

    @Override
    public void cleanUp() {
        this.cleanUp(true);
    }

    @Override
    public void cleanUpWithoutDisposingWindows() {
        this.cleanUp(false);
    }

    private void cleanUp(boolean disposeWindows) {
        if (disposeWindows) {
            this.disposeWindows();
        }
        this.releaseMouseButtons();
        ScreenLock.instance().release(this);
    }

    private void disposeWindows() {
        for (Container container : this.roots()) {
            if (!(container instanceof Window)) continue;
            Window w = (Window)container;
            this.hierarchy.dispose(w);
            w.setVisible(false);
            w.dispose();
        }
    }

    private Collection<? extends Container> roots() {
        return this.hierarchy.roots();
    }

    @Override
    public void click(Component c) {
        this.click(c, MouseButton.LEFT_BUTTON);
    }

    @Override
    public void rightClick(Component c) {
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @Override
    public void click(Component c, MouseButton button) {
        this.click(c, button, 1);
    }

    @Override
    public void doubleClick(Component c) {
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @Override
    public void click(Component c, MouseButton button, int times) {
        this.click(c, AWT.centerOf(c), button, times);
    }

    @Override
    public void click(Component c, Point where) {
        this.click(c, where, MouseButton.LEFT_BUTTON, 1);
    }

    @Override
    public void click(Component c, Point where, MouseButton button, int times) {
        this.focus(c);
        int mask = button.mask;
        int modifierMask = mask & 0xFFFFFFE3;
        mask &= 0x1C;
        this.pressModifiers(modifierMask);
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (times > 1 && delayBetweenEvents * 2 > 200) {
            this.settings.delayBetweenEvents(0);
        }
        this.eventGenerator().pressMouse(c, where, mask);
        for (int i = times; i > 1; --i) {
            this.eventGenerator().releaseMouse(mask);
            this.eventGenerator().pressMouse(mask);
        }
        this.settings.delayBetweenEvents(delayBetweenEvents);
        this.eventGenerator().releaseMouse(mask);
        this.releaseModifiers(modifierMask);
        this.waitForIdle();
    }

    @Override
    public void pressModifiers(int modifierMask) {
        for (int modifierKey : Modifiers.keysFor(modifierMask)) {
            this.pressKey(modifierKey);
        }
    }

    @Override
    public void releaseModifiers(int modifierMask) {
        int[] modifierKeys = Modifiers.keysFor(modifierMask);
        for (int i = modifierKeys.length - 1; i >= 0; --i) {
            this.releaseKey(modifierKeys[i]);
        }
    }

    @Override
    public void pressMouse(MouseButton button) {
        this.eventGenerator().pressMouse(button.mask);
    }

    @Override
    public void pressMouse(Component c, Point where) {
        this.pressMouse(c, where, MouseButton.LEFT_BUTTON);
    }

    @Override
    public void pressMouse(Component c, Point where, MouseButton button) {
        this.jitter(c, where);
        this.moveMouse(c, where.x, where.y);
        this.eventGenerator().pressMouse(c, where, button.mask);
    }

    @Override
    public void jitter(Component c) {
        this.jitter(c, AWT.centerOf(c));
    }

    @Override
    public void jitter(Component c, Point where) {
        int x = where.x;
        int y = where.y;
        this.moveMouse(c, x > 0 ? x - 1 : x + 1, y);
    }

    @Override
    public void moveMouse(Component c) {
        this.moveMouse(c, AWT.centerOf(c));
    }

    @Override
    public void moveMouse(Component c, Point p) {
        this.moveMouse(c, p.x, p.y);
    }

    @Override
    public void moveMouse(Component c, int x, int y) {
        if (!this.waitForComponentToBeReady(c, this.settings.timeoutToBeVisible())) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Could not obtain position of component ", Formatting.format(c)}));
        }
        this.eventGenerator().moveMouse(c, x, y);
    }

    private boolean waitForComponentToBeReady(Component c, long timeout) {
        if (this.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.isReadyForInput(c)) {
            Component invoker;
            if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                this.jitter(invoker, new Point(invoker.getWidth() / 2, invoker.getHeight() / 2));
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @Override
    public void enterText(String text) {
        if (Strings.isEmpty((String)text)) {
            return;
        }
        for (char character : text.toCharArray()) {
            this.type(character);
        }
    }

    @Override
    public void type(char character) {
        KeyStroke keyStroke = KeyStrokeMap.keyStrokeFor(character);
        if (keyStroke == null) {
            Component focus = FocusOwnerFinder.focusOwner();
            if (focus == null) {
                return;
            }
            KeyEvent keyEvent = this.keyEventFor(focus, character);
            if (this.isRobotMode()) {
                this.waitForIdle();
            }
            this.eventPoster.postEvent(focus, keyEvent);
            return;
        }
        this.keyPressAndRelease(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    private boolean isRobotMode() {
        return EventMode.ROBOT.equals((Object)this.settings.eventMode());
    }

    private KeyEvent keyEventFor(Component c, char character) {
        return new KeyEvent(c, 400, System.currentTimeMillis(), 0, 0, character);
    }

    private EventQueue eventQueueFor(Component c) {
        return c != null ? windowMonitor.eventQueueFor(c) : toolkit.getSystemEventQueue();
    }

    @Override
    public void pressAndReleaseKey(int keyCode, int ... modifiers) {
        this.keyPressAndRelease(keyCode, InputModifiers.unify(modifiers));
    }

    @Override
    public void pressAndReleaseKeys(int ... keyCodes) {
        for (int keyCode : keyCodes) {
            this.keyPressAndRelease(keyCode, 0);
            this.waitForIdle();
        }
    }

    private void keyPressAndRelease(int keyCode, int modifiers) {
        int updatedModifiers = Modifiers.updateModifierWithKeyCode(keyCode, modifiers);
        this.pressModifiers(updatedModifiers);
        if (updatedModifiers == modifiers) {
            this.keyPress(keyCode);
            this.eventGenerator().releaseKey(keyCode);
        }
        this.releaseModifiers(updatedModifiers);
    }

    @Override
    public void pressKey(int keyCode) {
        this.keyPress(keyCode);
        this.waitForIdle();
    }

    private void keyPress(int keyCode) {
        this.eventGenerator().pressKey(keyCode, '\uffff');
    }

    @Override
    public void releaseKey(int keyCode) {
        this.eventGenerator().releaseKey(keyCode);
        this.waitForIdle();
    }

    @Override
    public void releaseLeftMouseButton() {
        this.releaseMouseButton(MouseButton.LEFT_BUTTON);
    }

    @Override
    public void releaseMouseButton(MouseButton button) {
        this.mouseRelease(button.mask);
    }

    @Override
    public void releaseMouseButtons() {
        int buttons = inputState.buttons();
        if (buttons == 0) {
            return;
        }
        this.mouseRelease(buttons);
    }

    private void mouseRelease(int buttons) {
        this.eventGenerator().releaseMouse(buttons);
    }

    private InputEventGenerator eventGenerator() {
        return this.eventGenerators.current();
    }

    @Override
    public void waitForIdle() {
        this.waitIfNecessary();
        Collection<EventQueue> queues = windowMonitor.allEventQueues();
        if (queues.size() == 1) {
            this.waitForIdle(toolkit.getSystemEventQueue());
            return;
        }
        for (EventQueue queue : queues) {
            this.waitForIdle(queue);
        }
    }

    private void waitIfNecessary() {
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        int eventPostingDelay = this.settings.eventPostingDelay();
        if (eventPostingDelay > delayBetweenEvents) {
            Pause.pause(eventPostingDelay - delayBetweenEvents);
        }
    }

    private void waitForIdle(EventQueue eventQueue) {
        int idleTimeout;
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        while (!this.postInvocationEvent(eventQueue, idleTimeout = this.settings.idleTimeout()) && System.currentTimeMillis() - start <= (long)idleTimeout) {
            ++count;
            Pause.pause();
            if (eventQueue.peekEvent() != null) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postInvocationEvent(EventQueue eventQueue, long timeout) {
        RobotIdleLock lock;
        RobotIdleLock robotIdleLock = lock = new RobotIdleLock();
        synchronized (robotIdleLock) {
            eventQueue.postEvent(new InvocationEvent((Object)toolkit, EMPTY_RUNNABLE, lock, true));
            long start = System.currentTimeMillis();
            try {
                lock.wait(timeout);
                return System.currentTimeMillis() - start >= (long)this.settings.idleTimeout();
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }

    @Override
    public boolean isDragging() {
        return inputState.dragInProgress();
    }

    @Override
    public JPopupMenu showPopupMenu(Component invoker) {
        return this.showPopupMenu(invoker, AWT.centerOf(invoker));
    }

    @Override
    public JPopupMenu showPopupMenu(Component invoker, Point location) {
        this.click(invoker, location, MouseButton.RIGHT_BUTTON, 1);
        JPopupMenu popup = this.findActivePopupMenu();
        if (popup == null) {
            throw new ComponentLookupException(Strings.concat((Object[])new Object[]{"Unable to show popup at ", location, " on ", Formatting.format(invoker)}));
        }
        long start = System.currentTimeMillis();
        while (!this.isReadyForInput(SwingUtilities.getWindowAncestor(popup)) && System.currentTimeMillis() - start > 10000L) {
            Pause.pause();
        }
        return popup;
    }

    @Override
    public boolean isReadyForInput(Component c) {
        if (this.isAWTMode()) {
            return c.isShowing();
        }
        Window w = WindowAncestorFinder.ancestorOf(c);
        if (w == null) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Component ", Formatting.format(c), " does not have a Window ancestor"}));
        }
        return c.isShowing() && windowMonitor.isWindowReady(w);
    }

    private boolean isAWTMode() {
        return EventMode.AWT.equals((Object)this.settings.eventMode());
    }

    @Override
    public JPopupMenu findActivePopupMenu() {
        JPopupMenu popup = this.activePopupMenu();
        if (popup != null || SwingUtilities.isEventDispatchThread()) {
            return popup;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(5000L);
        while ((popup = this.activePopupMenu()) == null && !watch.isTimeOut()) {
            Pause.pause(100L);
        }
        return popup;
    }

    private JPopupMenu activePopupMenu() {
        try {
            return (JPopupMenu)this.finder().find(POPUP_MATCHER);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    @Override
    public void requireNoJOptionPaneIsShowing() {
        try {
            JOptionPane found = this.finder().findByType(JOptionPane.class, true);
            if (found == null) {
                return;
            }
            Fail.fail((String)Strings.concat((Object[])new Object[]{"Expecting no JOptionPane to be showing, but found:<", Formatting.format(found), ">"}));
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public ComponentHierarchy hierarchy() {
        return this.hierarchy;
    }

    private static class RobotIdleLock {
        RobotIdleLock() {
        }
    }
}

