/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import org.fest.swing.core.ComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Strings;

public final class NameMatcher
implements ComponentMatcher {
    private final String name;
    private final boolean requireShowing;

    public NameMatcher(String name) {
        this(name, false);
    }

    public NameMatcher(String name, boolean requireShowing) {
        if (name == null) {
            throw new NullPointerException("The name of the component to find should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the component to find should not be empty");
        }
        this.name = name;
        this.requireShowing = requireShowing;
    }

    public boolean matches(Component c) {
        return Objects.areEqual((Object)this.name, (Object)c.getName()) && (!this.requireShowing() || c.isShowing());
    }

    public final boolean requireShowing() {
        return this.requireShowing;
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "name=", Strings.quote((String)this.name), ", ", "requireShowing=", String.valueOf(this.requireShowing), "]"});
    }
}

