/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;

public final class IntAssert
extends PrimitiveAssert {
    private static final int ZERO = 0;
    private final int actual;

    IntAssert(int actual) {
        this.actual = actual;
    }

    public IntAssert as(String description) {
        return (IntAssert)this.description(description);
    }

    public IntAssert describedAs(String description) {
        return this.as(description);
    }

    public IntAssert isEqualTo(int expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public IntAssert isNotEqualTo(int value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public IntAssert isGreaterThan(int value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public IntAssert isLessThan(int value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public IntAssert isGreaterThanOrEqualTo(int value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public IntAssert isLessThanOrEqualTo(int value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public IntAssert isPositive() {
        return this.isGreaterThan(0);
    }

    public IntAssert isNegative() {
        return this.isLessThan(0);
    }

    public IntAssert isZero() {
        return this.isEqualTo(0);
    }
}

